/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;

public class DataManagerMessage<T, I> {
    private final ResourceKey<IDataManager<T>> key;
    private final IDataManager<T> manager;
    private final IJsonDataSerializer<T, I> serializer;
    private final Map<ResourceLocation, T> data;
    private Map<ResourceLocation, I> intermediateData;

    public DataManagerMessage(ResourceLocation id) {
        this(IDataManager.createManagerKey(id));
    }

    public DataManagerMessage(ResourceKey<? super IDataManager<T>> key) {
        this.key = key;
        this.manager = DataPackAnvil.WRAPPER.getManager(key);
        this.serializer = DataPackAnvil.WRAPPER.getSerializer(key);
        this.data = new HashMap<ResourceLocation, T>(this.manager.getData());
        this.intermediateData = new HashMap<ResourceLocation, I>();
    }

    public void decode(FriendlyByteBuf buf) {
        try {
            int mapSize = buf.readInt();
            this.intermediateData = new HashMap<ResourceLocation, I>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                this.intermediateData.put(buf.m_130281_(), this.serializer.read(buf));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while decoding network packet for DataManger " + this.key, e);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.data.size());
        this.data.forEach((loc, prop) -> this.encodeSingleData(buf, (ResourceLocation)loc, (T)prop));
    }

    private void encodeSingleData(FriendlyByteBuf buf, ResourceLocation loc, T prop) {
        try {
            buf.m_130085_(loc);
            this.serializer.write(prop, buf);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while encoding network packet for DataManger " + this.key + ", " + loc + " has invalid data", e);
        }
    }

    public void process() {
        try {
            this.data.clear();
            for (Map.Entry<ResourceLocation, I> entry : this.intermediateData.entrySet()) {
                this.data.put(entry.getKey(), this.serializer.read(entry.getValue()));
            }
            this.manager.setData(this.data);
        }
        catch (Exception e) {
            DataManagerWrapper.logManagerException(this.key, e);
        }
    }

    public ResourceLocation getId() {
        return this.key.m_135782_();
    }
}

