/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import sirttas.dpanvil.api.data.IDataManager;

public class DataReference<T>
implements Holder<T> {
    private final IDataManager<T> dataManager;
    private Set<TagKey<T>> tags = Set.of();
    @Nullable
    private ResourceKey<T> key;
    @Nullable
    private T value;

    public DataReference(IDataManager<T> dataManager, @Nullable ResourceKey<T> key, @Nullable T value) {
        this.dataManager = dataManager;
        this.key = key;
        this.value = value;
    }

    public ResourceKey<T> key() {
        if (this.key == null) {
            throw new IllegalStateException("Trying to access unbound value '" + this.value + "' from data manager " + this.dataManager);
        }
        return this.key;
    }

    @Nonnull
    public T m_203334_() {
        if (this.value == null) {
            throw new IllegalStateException("Trying to access unbound value '" + this.key + "' from data manager " + this.dataManager);
        }
        return this.value;
    }

    public boolean m_203373_(@Nonnull ResourceLocation id) {
        return this.key().m_135782_().equals((Object)id);
    }

    public boolean m_203565_(@Nonnull ResourceKey<T> key) {
        return this.key() == key;
    }

    public boolean m_203656_(@Nonnull TagKey<T> tagKey) {
        return this.tags.contains(tagKey);
    }

    public boolean m_203425_(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key());
    }

    @Nonnull
    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.left(this.key());
    }

    @Nonnull
    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.of(this.key());
    }

    @Nonnull
    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public boolean m_203401_(@Nonnull HolderOwner<T> owner) {
        return true;
    }

    public boolean m_203633_() {
        return this.key != null && this.value != null;
    }

    public void bind(ResourceKey<T> key, T value) {
        if (this.key != null && key != this.key) {
            throw new IllegalStateException("Can't change holder key: existing=" + this.key + ", new=" + key);
        }
        this.key = key;
        this.value = value;
    }

    public void bindTags(Collection<TagKey<T>> tagKeys) {
        this.tags = Set.copyOf(tagKeys);
    }

    @Nonnull
    public Stream<TagKey<T>> m_203616_() {
        return this.tags.stream();
    }

    public String toString() {
        return "Reference{" + this.key + "=" + this.value + "}";
    }
}

