/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public record CacheBlockPredicate(IBlockPosPredicate predicate) implements IBlockPosPredicate
{
    public static final String NAME = "cache";
    public static final Codec<CacheBlockPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IBlockPosPredicate.CODEC.fieldOf("value").forGetter(CacheBlockPredicate::predicate)).apply((Applicative)builder, CacheBlockPredicate::new));

    @Override
    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        Object object;
        if (level instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            object = new CacheLevel(accessor);
        } else {
            object = level;
        }
        return this.predicate.test((LevelReader)object, pos, direction);
    }

    public BlockPosPredicateType<CacheBlockPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.CACHE.get();
    }

    private static class CacheLevel
    implements ServerLevelAccessor {
        private final ServerLevel level;
        private final Map<BlockPos, BlockEntity> blockEntityCache;

        public CacheLevel(ServerLevelAccessor level) {
            this.level = level.m_6018_();
            this.blockEntityCache = new HashMap<BlockPos, BlockEntity>();
        }

        @Nonnull
        public ServerLevel m_6018_() {
            return this.level;
        }

        public long m_183596_() {
            return this.level.m_183596_();
        }

        @Nonnull
        public LevelTickAccess<Block> m_183326_() {
            return this.level.m_183326_();
        }

        @Nonnull
        public LevelTickAccess<Fluid> m_183324_() {
            return this.level.m_183324_();
        }

        @Nonnull
        public LevelData m_6106_() {
            return this.level.m_6106_();
        }

        @Nonnull
        public DifficultyInstance m_6436_(@Nonnull BlockPos pos) {
            return this.level.m_6436_(pos);
        }

        @Nullable
        public MinecraftServer m_7654_() {
            return this.level.m_7654_();
        }

        @Nonnull
        public ChunkSource m_7726_() {
            return this.level.m_7726_();
        }

        @Nonnull
        public RandomSource m_213780_() {
            return this.level.m_213780_();
        }

        public void m_5594_(@Nullable Player player, @Nonnull BlockPos pos, @Nonnull SoundEvent sound, @Nonnull SoundSource category, float volume, float pitch) {
            this.level.m_5594_(player, pos, sound, category, volume, pitch);
        }

        public void m_7106_(@Nonnull ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            this.level.m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }

        public void m_5898_(@Nullable Player player, int type, @Nonnull BlockPos pos, int data) {
            this.level.m_5898_(player, type, pos, data);
        }

        public void m_214171_(@Nonnull GameEvent event, @Nonnull Vec3 position, @Nonnull GameEvent.Context context) {
            this.level.m_214171_(event, position, context);
        }

        @Nonnull
        public RegistryAccess m_9598_() {
            return this.level.m_9598_();
        }

        @Nonnull
        public FeatureFlagSet m_246046_() {
            return this.level.m_246046_();
        }

        public float m_7717_(@Nonnull Direction direction, boolean pShade) {
            return this.level.m_7717_(direction, pShade);
        }

        @Nonnull
        public LevelLightEngine m_5518_() {
            return this.level.m_5518_();
        }

        @Nonnull
        public WorldBorder m_6857_() {
            return this.level.m_6857_();
        }

        @Nullable
        public synchronized BlockEntity m_7702_(@Nonnull BlockPos pos) {
            return this.blockEntityCache.computeIfAbsent(pos, arg_0 -> ((ServerLevel)this.level).m_7702_(arg_0));
        }

        @Nonnull
        public BlockState m_8055_(@Nonnull BlockPos pos) {
            return this.level.m_8055_(pos);
        }

        @Nonnull
        public FluidState m_6425_(@Nonnull BlockPos pos) {
            return this.level.m_6425_(pos);
        }

        @Nonnull
        public List<Entity> m_6249_(@Nullable Entity entity, @Nonnull AABB area, @Nonnull Predicate<? super Entity> predicate) {
            return this.level.m_6249_(entity, area, predicate);
        }

        @Nonnull
        public <T extends Entity> List<T> m_142425_(@Nonnull EntityTypeTest<Entity, T> entityTypeTest, @Nonnull AABB area, @Nonnull Predicate<? super T> predicate) {
            return this.level.m_142425_(entityTypeTest, area, predicate);
        }

        @Nonnull
        public List<? extends Player> m_6907_() {
            return this.level.m_6907_();
        }

        @Nullable
        public ChunkAccess m_6522_(int pX, int pZ, @Nonnull ChunkStatus requiredStatus, boolean pNonnull) {
            return this.level.m_6522_(pX, pZ, requiredStatus, pNonnull);
        }

        public int m_6924_(@Nonnull Heightmap.Types heightmapType, int pX, int pZ) {
            return this.level.m_6924_(heightmapType, pX, pZ);
        }

        public int m_7445_() {
            return this.level.m_7445_();
        }

        @Nonnull
        public BiomeManager m_7062_() {
            return this.level.m_7062_();
        }

        @Nonnull
        public Holder<Biome> m_203675_(int pX, int pY, int pZ) {
            return this.level.m_203675_(pX, pY, pZ);
        }

        public boolean m_5776_() {
            return this.level.m_5776_();
        }

        public int m_5736_() {
            return this.level.m_5736_();
        }

        @Nonnull
        public DimensionType m_6042_() {
            return this.level.m_6042_();
        }

        public boolean m_7433_(@Nonnull BlockPos pos, @Nonnull Predicate<BlockState> state) {
            return this.level.m_7433_(pos, state);
        }

        public boolean m_142433_(@Nonnull BlockPos pos, @Nonnull Predicate<FluidState> predicate) {
            return this.level.m_142433_(pos, predicate);
        }

        public boolean m_6933_(@Nonnull BlockPos pos, @Nonnull BlockState state, int pFlags, int pRecursionLeft) {
            return this.level.m_6933_(pos, state, pFlags, pRecursionLeft);
        }

        public boolean m_7471_(@Nonnull BlockPos pos, boolean pIsMoving) {
            return this.level.m_7471_(pos, pIsMoving);
        }

        public boolean m_7740_(@Nonnull BlockPos pos, boolean pDropBlock, @Nullable Entity pEntity, int pRecursionLeft) {
            return this.level.m_7740_(pos, pDropBlock, pEntity, pRecursionLeft);
        }
    }
}

