/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.rewind;

import com.hollingsworth.arsnouveau.common.entity.debug.FixedStack;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRewind;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindEntityData;
import java.util.Stack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class RewindEntityMixin
implements IRewindable {
    @Shadow
    public Level f_19853_;
    @Unique
    public Stack<RewindEntityData> ars_Nouveau$motions = null;
    @Unique
    public boolean an_isRewinding = false;

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract void m_142687_(Entity.RemovalReason var1);

    @Shadow
    public abstract boolean m_20137_(String var1);

    @Shadow
    public abstract Vec3 m_20182_();

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        Entity entity;
        if (this.ars_Nouveau$motions == null) {
            this.ars_Nouveau$motions = new FixedStack<RewindEntityData>(EffectRewind.INSTANCE.getEntityMaxTrackingTicks());
        }
        if (!EffectRewind.shouldRecordData(entity = (Entity)this, this) || this.f_19853_ == null) {
            return;
        }
        float health = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            health = living.m_21223_();
        }
        RewindEntityData data = new RewindEntityData(this.f_19853_.m_46467_(), this.m_20184_(), this.m_20182_(), health);
        this.ars_Nouveau$motions.push(data);
    }

    @Inject(method={"setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void anSetDeltaMovement(Vec3 pDeltaMovement, CallbackInfo ci) {
        if (!EffectRewind.shouldAllowMovement(this)) {
            ci.cancel();
        }
    }

    @Inject(method={"setDeltaMovement(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void anSetDeltaMovement(double pX, double pY, double pZ, CallbackInfo ci) {
        if (!EffectRewind.shouldAllowMovement(this)) {
            ci.cancel();
        }
    }

    @Override
    public Stack<RewindEntityData> getMotions() {
        return this.ars_Nouveau$motions == null ? new FixedStack(0) : this.ars_Nouveau$motions;
    }

    @Override
    public void setRewinding(boolean rewinding) {
        this.an_isRewinding = rewinding;
    }

    @Override
    public boolean isRewinding() {
        return this.an_isRewinding;
    }
}

