/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.ColorParticleTypeData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class HelixParticleTypeData
extends ColorParticleTypeData {
    float angle;
    float radius;
    float radiusY;
    float speed;
    public static final Codec<HelixParticleTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age), (App)Codec.FLOAT.fieldOf("angle").forGetter(d -> Float.valueOf(d.angle)), (App)Codec.FLOAT.fieldOf("radius").forGetter(d -> Float.valueOf(d.radius)), (App)Codec.FLOAT.fieldOf("radiusY").forGetter(d -> Float.valueOf(d.radiusY)), (App)Codec.FLOAT.fieldOf("speed").forGetter(d -> Float.valueOf(d.speed))).apply((Applicative)instance, HelixParticleTypeData::new));
    static final ParticleOptions.Deserializer<HelixParticleTypeData> DESERIALIZER = new ParticleOptions.Deserializer<HelixParticleTypeData>(){

        public HelixParticleTypeData fromCommand(ParticleType<HelixParticleTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new HelixParticleTypeData(type, ParticleColor.fromString(reader.readString()), reader.readBoolean(), 0.0f, 0.2f, 0.1f, 0.2f);
        }

        public HelixParticleTypeData fromNetwork(ParticleType<HelixParticleTypeData> type, FriendlyByteBuf buffer) {
            return new HelixParticleTypeData(type, ParticleColorRegistry.from(buffer.m_130260_()), buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };

    public HelixParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age) {
        super(r, g, b, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        super(color, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float angle, float radius, float radiusY, float speed) {
        super(particleTypeData, color, disableDepthTest);
        this.angle = angle;
        this.radius = radius;
        this.radiusY = radiusY;
        this.speed = speed;
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        super(particleTypeData, color, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age, float angle, float radius, float radiusY, float speed) {
        this((ParticleType<HelixParticleTypeData>)((ParticleType)ModParticles.HELIX_TYPE.get()), new ParticleColor(r, g, b), disableDepthTest, size, alpha, age, angle, radius, radiusY, speed);
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age, float offset, float radius, float radiusY, float speed) {
        super(particleTypeData, color, disableDepthTest, size, alpha, age);
        this.angle = offset;
        this.radius = radius;
        this.radiusY = radiusY;
        this.speed = speed;
    }

    @Override
    public void m_7711_(FriendlyByteBuf packetBuffer) {
        super.m_7711_(packetBuffer);
        packetBuffer.writeFloat(this.angle);
        packetBuffer.writeFloat(this.radius);
        packetBuffer.writeFloat(this.radiusY);
        packetBuffer.writeFloat(this.speed);
    }

    @Override
    public String m_5942_() {
        return super.m_5942_();
    }
}

