/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.event.DelayedSpellEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CancelReason;
import com.hollingsworth.arsnouveau.api.spell.IContextAttachment;
import com.hollingsworth.arsnouveau.api.spell.IContextManipulator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class SpellContext
implements Cloneable {
    private boolean isCanceled;
    @Nullable
    private CancelReason cancelReason;
    private Spell spell;
    private ItemStack casterTool = ItemStack.f_41583_;
    @Nullable
    private LivingEntity caster;
    private int currentIndex;
    @Nullable
    public BlockEntity castingTile;
    private ParticleColor colors = ParticleColor.defaultParticleColor();
    private CasterType type;
    private Level level;
    public CompoundTag tag = new CompoundTag();
    private IWrappedCaster wrappedCaster;
    private SpellContext previousContext;
    private DelayedSpellEvent delayedSpellEvent;
    public Map<ResourceLocation, IContextAttachment> attachments = new HashMap<ResourceLocation, IContextAttachment>();

    public SpellContext(Level level, @NotNull Spell spell, @Nullable LivingEntity caster, IWrappedCaster wrappedCaster) {
        this.level = level;
        this.spell = spell;
        this.caster = caster;
        this.colors = spell.color.clone();
        this.wrappedCaster = wrappedCaster;
    }

    public SpellContext(Level level, @NotNull Spell spell, @Nullable LivingEntity caster, IWrappedCaster wrappedCaster, ItemStack casterTool) {
        this(level, spell, caster, wrappedCaster);
        this.casterTool = casterTool.m_41777_();
    }

    public static SpellContext fromEntity(@NotNull Spell spell, @NotNull LivingEntity caster, ItemStack castingTool) {
        return new SpellContext(caster.f_19853_, spell, caster, LivingCaster.from(caster), castingTool);
    }

    public SpellContext withWrappedCaster(IWrappedCaster caster) {
        this.wrappedCaster = caster;
        if (caster instanceof LivingCaster) {
            LivingCaster livingCaster = (LivingCaster)caster;
            this.caster = livingCaster.livingEntity;
        }
        return this;
    }

    public SpellContext withParent(SpellContext parent) {
        this.previousContext = parent;
        return this;
    }

    public <T extends IContextAttachment> T getOrCreateAttachment(ResourceLocation id, T attachment) {
        return (T)this.attachments.computeIfAbsent(id, k -> attachment);
    }

    @Nullable
    public <T extends IContextAttachment> T getAttachment(ResourceLocation id) {
        return (T)this.attachments.get(id);
    }

    @Nullable
    public AbstractSpellPart nextPart() {
        ++this.currentIndex;
        AbstractSpellPart part = null;
        try {
            part = this.getSpell().recipe.get(this.currentIndex - 1);
        }
        catch (Throwable e) {
            System.out.println("=======");
            System.out.println("Invalid spell cast found! This is a bug and should be reported!");
            System.out.println(this.spell.getDisplayString());
            System.out.println("Casting player: ");
            System.out.println(this.caster);
            System.out.println("Casting tile:");
            System.out.println(this.castingTile);
            System.out.println("=======");
            e.printStackTrace();
        }
        return part;
    }

    @NotNull
    public SpellContext makeChildContext() {
        Spell remainder = this.getRemainingSpell();
        for (AbstractSpellPart spellPart : remainder.recipe) {
            if (!(spellPart instanceof IContextManipulator)) continue;
            IContextManipulator manipulator = (IContextManipulator)((Object)spellPart);
            boolean shouldPush = manipulator.shouldPushContext(this);
            SpellContext newContext = manipulator.manipulate(this);
            if (newContext == null || !shouldPush) continue;
            newContext.withParent(this);
            return newContext;
        }
        SpellContext newContext = this.clone();
        newContext.previousContext = this;
        newContext.spell = remainder;
        newContext.currentIndex = 0;
        return newContext;
    }

    public boolean hasNextPart() {
        return this.spell.isValid() && !this.isCanceled() && !this.isDelayed() && this.currentIndex < this.spell.recipe.size();
    }

    public SpellContext resetCastCounter() {
        this.currentIndex = 0;
        this.isCanceled = false;
        return this;
    }

    public SpellContext withColors(ParticleColor colors) {
        this.colors = colors;
        return this;
    }

    public SpellContext withSpell(Spell spell) {
        this.spell = spell;
        return this;
    }

    @NotNull
    public LivingEntity getUnwrappedCaster() {
        Object shooter = this.caster;
        if (shooter == null && this.castingTile != null) {
            shooter = ANFakePlayer.getPlayer((ServerLevel)this.level);
            BlockPos pos = this.castingTile.m_58899_();
            shooter.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        shooter = shooter == null ? ANFakePlayer.getPlayer((ServerLevel)this.level) : shooter;
        return shooter;
    }

    @NotNull
    public IWrappedCaster getCaster() {
        return this.wrappedCaster;
    }

    public ItemStack getCasterTool() {
        return this.casterTool;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public CasterType getType() {
        return this.type == null ? this.wrappedCaster.getCasterType() : this.type;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.setCanceled(canceled, CancelReason.NEW_CONTEXT);
    }

    public boolean setCanceled(boolean canceled, @Nullable CancelReason cancelReason) {
        block1: {
            AbstractSpellPart spellPart;
            boolean keepChecking;
            this.isCanceled = canceled;
            this.cancelReason = cancelReason;
            if (!this.isCanceled) break block1;
            Spell remainder = this.getRemainingSpell();
            Iterator<AbstractSpellPart> iterator = remainder.recipe.iterator();
            while (iterator.hasNext() && (keepChecking = (spellPart = iterator.next()).contextCanceled(this))) {
            }
        }
        return this.isCanceled;
    }

    public void stop() {
        this.isCanceled = true;
        this.cancelReason = CancelReason.TERMINATED;
    }

    public void delay(DelayedSpellEvent spellEvent) {
        this.delayedSpellEvent = spellEvent;
    }

    public DelayedSpellEvent getDelayedSpellEvent() {
        return this.delayedSpellEvent;
    }

    public boolean isDelayed() {
        return this.delayedSpellEvent != null && this.delayedSpellEvent.duration > 0;
    }

    @NotNull
    public Spell getSpell() {
        return this.spell == null ? new Spell() : this.spell;
    }

    @NotNull
    public Spell getRemainingSpell() {
        Spell remainder = this.getSpell().clone();
        if (this.getCurrentIndex() >= this.getSpell().recipe.size()) {
            return remainder.setRecipe(new ArrayList<AbstractSpellPart>());
        }
        return remainder.setRecipe(new ArrayList<AbstractSpellPart>(this.getSpell().recipe.subList(this.getCurrentIndex(), this.getSpell().recipe.size())));
    }

    @Nullable
    public SpellContext getPreviousContext() {
        return this.previousContext;
    }

    public SpellContext clone() {
        try {
            SpellContext clone = (SpellContext)super.clone();
            clone.spell = this.spell.clone();
            clone.colors = this.colors.clone();
            clone.tag = this.tag.m_6426_();
            clone.caster = this.caster;
            clone.castingTile = this.castingTile;
            clone.casterTool = this.casterTool.m_41777_();
            clone.type = this.type;
            clone.level = this.level;
            clone.wrappedCaster = this.wrappedCaster;
            clone.previousContext = this.previousContext == null ? null : this.previousContext.clone();
            clone.attachments = this.attachments.isEmpty() ? new HashMap<ResourceLocation, IContextAttachment>() : new HashMap<ResourceLocation, IContextAttachment>(this.attachments);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public ParticleColor getColors() {
        return this.colors.clone();
    }

    public void setColors(ParticleColor colors) {
        this.colors = colors;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
    }

    public void setCasterTool(ItemStack stack) {
        this.casterTool = stack.m_41777_();
    }

    @Nullable
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    public static class CasterType {
        public static final CasterType RUNE = new CasterType("rune");
        public static final CasterType TURRET = new CasterType("turret");
        public static final CasterType ENTITY = new CasterType("entity");
        public static final CasterType OTHER = new CasterType("other");
        public static final CasterType LIVING_ENTITY = new CasterType("living_entity");
        public static final CasterType PLAYER = new CasterType("player");
        public String id;

        public CasterType(String id) {
            this.id = id;
        }
    }
}

