/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.filters;

import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.shield.filters.AnimalFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.DefaultFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.HostileFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ItemFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class AbstractShieldFilter
implements ShieldFilter {
    private int action = 0;

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        CompoundTag tagCompound = new CompoundTag();
        this.writeToNBT(tagCompound);
        buf.m_130079_(tagCompound);
    }

    @Override
    public void readFromNBT(CompoundTag tagCompound) {
        this.action = tagCompound.m_128451_("action");
    }

    @Override
    public void writeToNBT(CompoundTag tagCompound) {
        tagCompound.m_128359_("type", this.getFilterName());
        tagCompound.m_128405_("action", this.action);
    }

    public static ShieldFilter createFilter(FriendlyByteBuf buf) {
        CompoundTag compound = buf.m_130260_();
        return AbstractShieldFilter.createFilter(compound);
    }

    public static ShieldFilter createFilter(CompoundTag compound) {
        String type = compound.m_128461_("type");
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.readFromNBT(compound);
        return filter;
    }

    public static ShieldFilter createFilter(String type) {
        AbstractShieldFilter filter;
        if ("animal".equals(type)) {
            filter = new AnimalFilter();
        } else if ("hostile".equals(type)) {
            filter = new HostileFilter();
        } else if ("player".equals(type)) {
            filter = new PlayerFilter();
        } else if ("item".equals(type)) {
            filter = new ItemFilter();
        } else if ("default".equals(type)) {
            filter = new DefaultFilter();
        } else {
            Logging.log((String)("Unknown filter type = " + type));
            filter = new DefaultFilter();
        }
        return filter;
    }
}

