/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcjty.rftoolsbuilder.modules.scanner.client.BlockEntry;
import mcjty.rftoolsbuilder.modules.scanner.client.DummyBlockGetter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class Renderer {
    private final ChunkBufferBuilderPack fixedBuffers = new ChunkBufferBuilderPack();
    private final Map<RenderType, VertexBuffer> buffers = RenderType.m_110506_().stream().collect(Collectors.toMap(key -> key, key -> new VertexBuffer(VertexBuffer.Usage.STATIC)));

    private static List<BlockEntry> setupBlocks(BlockPos pos) {
        BlockState cobble = Blocks.f_50652_.m_49966_();
        BlockState planks = Blocks.f_50705_.m_49966_();
        BlockState glass = Blocks.f_50058_.m_49966_();
        return new BlockEntry.Builder().add(pos, cobble).add(pos.m_122029_(), cobble).add(pos.m_122024_(), cobble).add(pos.m_122012_(), cobble).add(pos.m_122019_(), cobble).add(pos.m_122029_().m_7494_(), glass).add(pos.m_122024_().m_7494_(), glass).add(pos.m_122012_().m_7494_(), glass).add(pos.m_122019_().m_7494_(), glass).add(pos.m_122029_().m_122029_(), planks).add(pos.m_122024_().m_122024_(), planks).add(pos.m_122012_().m_122012_(), planks).add(pos.m_122019_().m_122019_(), planks).add(pos.m_7494_(), Blocks.f_50571_.m_49966_()).add(pos.m_122029_().m_122019_(), cobble).add(pos.m_122029_().m_122012_(), cobble).add(pos.m_122024_().m_122019_(), cobble).add(pos.m_122024_().m_122012_(), cobble).build();
    }

    public void render(PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        int rot = (int)(System.currentTimeMillis() / 25L) % 360;
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)rot));
        List usedLayers = RenderType.m_110506_();
        for (RenderType renderType : usedLayers) {
            renderType.m_110185_();
            ShaderInstance shader = RenderSystem.getShader();
            for (int i = 0; i < 12; ++i) {
                int texId = RenderSystem.getShaderTexture((int)i);
                shader.m_173350_("Sampler" + i, (Object)texId);
            }
            if (shader.f_173308_ != null) {
                shader.f_173308_.m_5679_(poseStack.m_85850_().m_252922_());
            }
            if (shader.f_173309_ != null) {
                shader.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
            }
            if (shader.f_173312_ != null) {
                shader.f_173312_.m_5941_(RenderSystem.getShaderColor());
            }
            if (shader.f_267422_ != null) {
                shader.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
            }
            if (shader.f_173315_ != null) {
                shader.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
            }
            if (shader.f_173316_ != null) {
                shader.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
            }
            if (shader.f_173317_ != null) {
                shader.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
            }
            if (shader.f_202432_ != null) {
                shader.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
            }
            if (shader.f_173310_ != null) {
                shader.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
            }
            if (shader.f_173319_ != null) {
                shader.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
            }
            RenderSystem.setupShaderLights((ShaderInstance)shader);
            shader.m_173363_();
            VertexBuffer buffer = this.buffers.get(renderType);
            buffer.m_85921_();
            buffer.m_166882_();
            renderType.m_110188_();
            shader.m_173362_();
        }
        VertexBuffer.m_85931_();
        poseStack.m_85849_();
    }

    public void buildBuffer(BlockPos pos) {
        BufferBuilder builder;
        List<BlockEntry> blocks = Renderer.setupBlocks(pos);
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        RandomSource random = Minecraft.m_91087_().f_91073_.m_213780_();
        DummyBlockGetter level = new DummyBlockGetter(Minecraft.m_91087_().f_91073_.m_9598_(), blocks);
        PoseStack buildingPoseStack = new PoseStack();
        int relX = blocks.get(0).pos().m_123341_();
        int relY = blocks.get(0).pos().m_123342_();
        int relZ = blocks.get(0).pos().m_123343_();
        for (RenderType renderType : RenderType.m_110506_()) {
            builder = this.fixedBuffers.m_108839_(renderType);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            for (BlockEntry block : blocks) {
                buildingPoseStack.m_85836_();
                buildingPoseStack.m_252880_((float)(block.pos().m_123341_() - relX), (float)(block.pos().m_123342_() - relY), (float)(block.pos().m_123343_() - relZ));
                BlockState state = block.state();
                blockRenderer.renderBatched(state, block.pos(), (BlockAndTintGetter)level, buildingPoseStack, (VertexConsumer)builder, false, random, ModelData.EMPTY, renderType);
                buildingPoseStack.m_85849_();
            }
        }
        for (RenderType renderType : RenderType.m_110506_()) {
            builder = this.fixedBuffers.m_108839_(renderType);
            BufferBuilder.RenderedBuffer renderedBuffer = builder.m_231168_();
            if (renderedBuffer == null) continue;
            VertexBuffer buffer = this.buffers.get(renderType);
            buffer.m_85921_();
            buffer.m_231221_(renderedBuffer);
        }
        VertexBuffer.m_85931_();
    }
}

