/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MCJsonUtils {
    public static <T> T getRegistryEntry(JsonObject json, String memberName, IForgeRegistry<T> registry) {
        if (json.has(memberName)) {
            return MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, registry);
        }
        throw new JsonSyntaxException("Missing required value " + memberName);
    }

    public static <T> T getRegistryEntry(JsonElement json, String memberName, IForgeRegistry<T> registry) {
        if (json == null) {
            throw new JsonSyntaxException("The property " + memberName + " is missing.");
        }
        if (json.isJsonPrimitive()) {
            String rawId = json.getAsString();
            ResourceLocation registryId = ResourceLocation.m_135820_((String)rawId);
            if (registryId != null) {
                Object registryEntry = registry.getValue(registryId);
                if (registryEntry != null) {
                    return (T)registryEntry;
                }
                throw new JsonSyntaxException("No entry found for id " + rawId);
            }
            throw new JsonSyntaxException("Registry id " + rawId + " for property " + memberName + " was not a valid format.");
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JSON primitive. was " + json.getClass());
    }

    public static Block getBlock(JsonObject json, String memberName) {
        return (Block)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.BLOCKS);
    }

    public static Fluid getFluid(JsonObject json, String memberName) {
        return (Fluid)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.FLUIDS);
    }

    public static Item getItem(JsonObject json, String memberName) {
        return (Item)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ITEMS);
    }

    public static Potion getPotion(JsonObject json, String memberName) {
        return (Potion)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.POTIONS);
    }

    public static Biome getBiome(JsonObject json, String memberName) {
        return (Biome)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.BIOMES);
    }

    public static SoundEvent getSound(JsonObject json, String memberName) {
        return (SoundEvent)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.SOUND_EVENTS);
    }

    public static Enchantment getEnchantment(JsonObject json, String memberName) {
        return (Enchantment)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ENCHANTMENTS);
    }

    public static EntityType<?> getEntity(JsonObject json, String memberName) {
        return (EntityType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ENTITY_TYPES);
    }

    public static BlockEntityType<?> getBlockEntity(JsonObject json, String memberName) {
        return (BlockEntityType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.BLOCK_ENTITY_TYPES);
    }

    public static ParticleType<?> getParticleType(JsonObject json, String memberName) {
        return (ParticleType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.PARTICLE_TYPES);
    }

    public static PaintingVariant getPainting(JsonObject json, String memberName) {
        return (PaintingVariant)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.PAINTING_VARIANTS);
    }
}

