/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.block_tracking;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import me.jellysquid.mods.lithium.common.entity.block_tracking.SectionedBlockChangeTracker;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;

public final class BlockCache {
    private static final int MIN_DELAY = 300;
    private int initDelay = 0;
    private AABB trackedPos = null;
    private SectionedBlockChangeTracker tracker = null;
    private long trackingSince;
    private boolean canSkipSupportingBlockSearch;
    private boolean canSkipBlockTouching;
    private byte cachedTouchingFireLava;
    private byte cachedIsSuffocating;
    private final Object2DoubleArrayMap<FluidType> fluidType2FluidHeightMap = new Object2DoubleArrayMap(2);

    public boolean isTracking() {
        return this.tracker != null;
    }

    public void initTracking(Entity entity) {
        if (this.isTracking()) {
            throw new IllegalStateException("Cannot init cache that is already initialized!");
        }
        this.tracker = SectionedBlockChangeTracker.registerAt(entity.m_9236_(), entity.m_20191_(), BlockStateFlags.ANY);
        this.initDelay = 0;
        this.resetCachedInfo();
    }

    public void updateCache(Entity entity) {
        if (this.isTracking() || this.initDelay >= 300) {
            AABB boundingBox = entity.m_20191_();
            if (boundingBox.equals((Object)this.trackedPos)) {
                if (!this.isTracking()) {
                    this.initTracking(entity);
                } else if (!this.tracker.isUnchangedSince(this.trackingSince)) {
                    this.resetCachedInfo();
                }
            } else {
                if (this.isTracking() && !this.tracker.matchesMovedBox(boundingBox)) {
                    this.tracker.unregister();
                    this.tracker = null;
                }
                this.resetTrackedPos(boundingBox);
            }
        } else {
            ++this.initDelay;
        }
    }

    public void resetTrackedPos(AABB boundingBox) {
        this.trackedPos = boundingBox;
        this.initDelay = 0;
        this.resetCachedInfo();
    }

    public void resetCachedInfo() {
        this.trackingSince = !this.isTracking() ? Long.MIN_VALUE : this.tracker.getWorldTime();
        this.canSkipSupportingBlockSearch = false;
        this.cachedIsSuffocating = (byte)-1;
        this.cachedTouchingFireLava = (byte)-1;
        this.canSkipBlockTouching = false;
        this.fluidType2FluidHeightMap.clear();
    }

    public void remove() {
        if (this.tracker != null) {
            this.tracker.unregister();
        }
    }

    public boolean canSkipBlockTouching() {
        return this.isTracking() && this.canSkipBlockTouching;
    }

    public void setCanSkipBlockTouching(boolean value) {
        this.canSkipBlockTouching = value;
    }

    public double getStationaryFluidHeightOrDefault(FluidType fluid, double defaultValue) {
        if (this.isTracking()) {
            return this.fluidType2FluidHeightMap.getOrDefault((Object)fluid, defaultValue);
        }
        return defaultValue;
    }

    public void setCachedFluidHeight(FluidType fluid, double fluidHeight) {
        this.fluidType2FluidHeightMap.put((Object)fluid, fluidHeight);
    }

    public Object2DoubleMap<FluidType> getCachedFluidHeightMap() {
        if (this.isTracking()) {
            return this.fluidType2FluidHeightMap;
        }
        return null;
    }

    public byte getIsTouchingFireLava() {
        if (this.isTracking()) {
            return this.cachedTouchingFireLava;
        }
        return -1;
    }

    public void setCachedTouchingFireLava(boolean b) {
        this.cachedTouchingFireLava = b ? (byte)1 : 0;
    }

    public byte getIsSuffocating() {
        if (this.isTracking()) {
            return this.cachedIsSuffocating;
        }
        return -1;
    }

    public void setCachedIsSuffocating(boolean b) {
        this.cachedIsSuffocating = b ? (byte)1 : 0;
    }

    public boolean canSkipSupportingBlockSearch() {
        return this.isTracking() && this.canSkipSupportingBlockSearch;
    }

    public void setCanSkipSupportingBlockSearch(boolean canSkip) {
        this.canSkipSupportingBlockSearch = canSkip;
    }
}

