/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LogisticallyLinkedBlockItem
extends BlockItem {
    public LogisticallyLinkedBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public boolean m_5812_(ItemStack pStack) {
        return LogisticallyLinkedBlockItem.isTuned(pStack);
    }

    public static boolean isTuned(ItemStack pStack) {
        return pStack.m_41782_() && pStack.m_41783_().m_128441_("BlockEntityTag");
    }

    @Nullable
    public static UUID networkFromStack(ItemStack pStack) {
        if (!LogisticallyLinkedBlockItem.isTuned(pStack)) {
            return null;
        }
        CompoundTag tag = pStack.m_41783_().m_128469_("BlockEntityTag");
        if (!tag.m_128403_("Freq")) {
            return null;
        }
        return tag.m_128342_("Freq");
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        if (!LogisticallyLinkedBlockItem.isTuned(pStack)) {
            return;
        }
        CompoundTag tag = pStack.m_41783_().m_128469_("BlockEntityTag");
        if (!tag.m_128403_("Freq")) {
            return;
        }
        CreateLang.translate("logistically_linked.tooltip", new Object[0]).style(ChatFormatting.GOLD).addTo(pTooltip);
        CreateLang.translate("logistically_linked.tooltip_clear", new Object[0]).style(ChatFormatting.GRAY).addTo(pTooltip);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            return super.m_6225_(pContext);
        }
        LogisticallyLinkedBehaviour link = BlockEntityBehaviour.get((BlockGetter)level, pos, LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = LogisticallyLinkedBlockItem.isTuned(stack);
        if (link != null) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            LogisticallyLinkedBlockItem.assignFrequency(stack, player, link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.m_5661_((Component)(tuned ? CreateLang.translateDirect("logistically_linked.connected", new Object[0]) : CreateLang.translateDirect("logistically_linked.new_network_started", new Object[0])), true);
        return useOn;
    }

    public static void assignFrequency(ItemStack stack, Player player, UUID frequency) {
        CompoundTag stackTag = stack.m_41784_();
        CompoundTag teTag = new CompoundTag();
        teTag.m_128362_("Freq", frequency);
        stackTag.m_128365_("BlockEntityTag", (Tag)teTag);
        player.m_5661_((Component)CreateLang.translateDirect("logistically_linked.tuned", new Object[0]), true);
        stack.m_41751_(stackTag);
    }
}

