/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.Borders;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.InfoPanel;
import com.brandon3055.brandonscore.client.gui.modulargui.ShaderEnergyBar;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.mojang.blaze3d.platform.Window;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiToolkit {
    private static final String INTERNAL_TRANSLATION_PREFIX = "gui_tkt.brandonscore.";
    private String translationPrefix = "";

    public GuiToolkit() {
    }

    public GuiToolkit(String translationPrefix) {
        this.setTranslationPrefix(translationPrefix);
    }

    private GuiToolkit setTranslationPrefix(String translationPrefix) {
        if (!((String)translationPrefix).endsWith(".") && !((String)translationPrefix).isEmpty()) {
            translationPrefix = (String)translationPrefix + ".";
        }
        this.translationPrefix = translationPrefix;
        return this;
    }

    public MutableComponent translate(String translationKey, Object ... args) {
        if (translationKey.startsWith(".")) {
            translationKey = translationKey.substring(1);
        }
        return Component.m_237110_((String)(this.translationPrefix + translationKey), (Object[])args);
    }

    public Supplier<MutableComponent> translate(Supplier<String> translationKey) {
        return () -> Component.m_237115_((String)(this.translationPrefix + (String)translationKey.get()));
    }

    protected static MutableComponent translateInternal(String translationKey) {
        if (translationKey.startsWith(".")) {
            translationKey = translationKey.substring(1);
        }
        return Component.m_237115_((String)(INTERNAL_TRANSLATION_PREFIX + translationKey));
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int size, Supplier<Material> iconSupplier) {
        return this.createIconButton(parent, size, iconSupplier, false);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int size, Supplier<Material> iconSupplier, boolean transHighlight) {
        return this.createIconButton(parent, size, size, iconSupplier, transHighlight);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonSize, int iconSize, String iconString) {
        return this.createIconButton(parent, buttonSize, iconSize, iconString, false);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonSize, int iconSize, String iconString, boolean transHighlight) {
        return this.createIconButton(parent, buttonSize, iconSize, BCGuiTextures.getter(iconString), transHighlight);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonSize, int iconSize, Supplier<Material> iconSupplier) {
        return this.createIconButton(parent, buttonSize, iconSize, iconSupplier, false);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonSize, int iconSize, Supplier<Material> iconSupplier, boolean transHighlight) {
        return this.createIconButton(parent, buttonSize, buttonSize, iconSize, iconSize, iconSupplier, transHighlight);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, String iconString) {
        return this.createIconButton(parent, buttonWidth, buttonHeight, iconWidth, iconHeight, iconString, false);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, String iconString, boolean transHighlight) {
        return this.createIconButton(parent, buttonWidth, buttonHeight, iconWidth, iconHeight, BCGuiTextures.getter(iconString), transHighlight);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, Supplier<Material> iconSupplier) {
        return this.createIconButton(parent, buttonWidth, buttonHeight, iconWidth, iconHeight, iconSupplier, false);
    }

    public GuiButton createIconButton(@NotNull GuiParent<?> parent, int buttonWidth, int buttonHeight, int iconWidth, int iconHeight, Supplier<Material> iconSupplier, boolean transHighlight) {
        GuiButton button = new GuiButton(parent);
        Constraints.size((ConstrainedGeometry)button, (double)buttonWidth, (double)buttonHeight);
        if (!transHighlight) {
            GuiToolkit.addHoverHighlight(button, null, false);
        }
        GuiTexture icon = new GuiTexture((GuiParent)button, iconSupplier);
        Constraints.size((ConstrainedGeometry)icon, (double)iconWidth, (double)iconHeight);
        Constraints.center((ConstrainedGeometry)icon, (ConstrainedGeometry)button);
        if (transHighlight) {
            GuiToolkit.addHoverHighlight(button, null, true);
        }
        return button;
    }

    public GuiButton createThemedIconButton(@NotNull GuiParent<?> parent, String iconString) {
        return this.createThemedIconButton(parent, 12, iconString);
    }

    public GuiButton createThemedIconButton(@NotNull GuiParent<?> parent, int size, String iconString) {
        return this.createIconButton(parent, size, BCGuiTextures.themedGetter(iconString));
    }

    public GuiButton createThemedIconButton(@NotNull GuiParent<?> parent, Supplier<Material> texture) {
        return this.createThemedIconButton(parent, 12, texture);
    }

    public GuiButton createThemedIconButton(@NotNull GuiParent<?> parent, int size, Supplier<Material> texture) {
        return this.createIconButton(parent, size, texture);
    }

    public static GuiRectangle addHoverHighlight(@NotNull GuiElement<?> parent) {
        return GuiToolkit.addHoverHighlight(parent, null, false);
    }

    public static GuiRectangle addHoverHighlight(@NotNull GuiElement<?> parent, @Nullable Borders borders, boolean transparent) {
        GuiRectangle rect = (GuiRectangle)new GuiRectangle(parent).fill(() -> Palette.Ctrl.fill(parent.isMouseOver()) & (transparent ? -2130706433 : -1)).setEnabled(() -> {
            GuiButton b;
            return parent.isMouseOver() || parent instanceof GuiButton && (b = (GuiButton)parent).toggleState();
        });
        Constraints.bind((ConstrainedGeometry)rect, parent, (Borders)(borders == null ? Borders.create((double)0.0) : borders));
        return rect;
    }

    public GuiButton createThemeButton(@NotNull GuiParent<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "theme");
        button.setTooltipSingle(() -> BCConfig.darkMode ? GuiToolkit.translateInternal("theme.light") : GuiToolkit.translateInternal("theme.dark"));
        button.onPress(() -> BCConfig.modifyClientProperty("darkMode", e -> e.setBoolean(!BCConfig.darkMode), new String[0]));
        return button;
    }

    public GuiButton createInfoButton(GuiElement<?> parent, InfoPanel panel) {
        GuiButton button = this.createIconButton((GuiParent<?>)parent, 12, BCGuiTextures.getter("info_panel"));
        button.setTooltipSingle(() -> GuiToolkit.translateInternal("info_panel." + (panel.expanded() ? "open" : "closed")));
        button.onPress(panel::toggleExpanded);
        return button;
    }

    public GuiButton createRSSwitch(@NotNull GuiParent<?> parent, IRSSwitchable switchable) {
        GuiButton button = new GuiButton(parent);
        Constraints.size((ConstrainedGeometry)button, (double)12.0, (double)12.0);
        GuiToolkit.addHoverHighlight(button);
        GuiTexture icon = new GuiTexture((GuiParent)button, () -> BCGuiTextures.get("redstone/" + switchable.getRSMode().name().toLowerCase(Locale.ENGLISH)));
        Constraints.bind((ConstrainedGeometry)icon, (ConstrainedGeometry)button);
        button.setTooltipSingle(() -> GuiToolkit.translateInternal("rs_mode." + switchable.getRSMode().name().toLowerCase(Locale.ENGLISH)));
        button.onPress(() -> switchable.setRSMode(switchable.getRSMode().next(Screen.m_96638_())), 0);
        button.onPress(() -> switchable.setRSMode(switchable.getRSMode().next(true)), 1);
        return button;
    }

    public GuiButton createFlat3DButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label) {
        GuiButton button = new GuiButton(parent);
        GuiRectangle border = new GuiRectangle((GuiParent)button).border(() -> button.isMouseOver() ? -1 : -16777216);
        GuiRectangle texture = new GuiRectangle((GuiParent)border);
        Supplier<Integer> tlCol = () -> button.isPressed() || button.toggleState() ? Palette.Ctrl.accentDark(true) : Palette.Ctrl.accentLight(button.isMouseOver());
        Supplier<Integer> brCol = () -> button.isPressed() || button.toggleState() ? Palette.Ctrl.accentLight(true) : Palette.Ctrl.accentDark(button.isMouseOver());
        texture.fill(() -> Palette.Ctrl.fill(border.isMouseOver() || button.isPressed() || button.toggleState()));
        texture.setEnabled(() -> !button.isDisabled());
        texture.setShadeTopLeft(tlCol);
        texture.setShadeBottomRight(brCol);
        texture.setShadeCorners(() -> GuiRender.midColour((int)((Integer)tlCol.get()), (int)((Integer)brCol.get())));
        GuiTexture disabledBG = ((GuiTexture)new GuiTexture((GuiParent)button, BCGuiTextures.themedGetter("button_disabled")).setEnabled(() -> ((GuiButton)button).isDisabled())).dynamicTexture();
        Constraints.bind((ConstrainedGeometry)disabledBG, (ConstrainedGeometry)button);
        if (label != null) {
            Window window = parent.mc().m_91268_();
            double xp = (float)window.m_85445_() / (float)window.m_85441_();
            double yp = (float)window.m_85446_() / (float)window.m_85442_();
            button.setLabel((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, label).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), () -> button.isPressed() ? -0.5 - xp : -0.5).precise())).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), () -> button.isPressed() ? 1.5 - yp : 1.5).precise())).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.WIDTH), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.HEIGHT))));
        }
        Constraints.bind((ConstrainedGeometry)border, (ConstrainedGeometry)button);
        Constraints.bind((ConstrainedGeometry)texture, (ConstrainedGeometry)border, (double)1.0);
        return button;
    }

    public GuiButton createResizeButton(@NotNull GuiParent<?> parent) {
        GuiButton button = this.createThemedIconButton(parent, "resize");
        button.setTooltipSingle(() -> GuiToolkit.translateInternal("large_view"));
        return button;
    }

    public GuiButton createBorderlessButton(@NotNull GuiParent<?> parent) {
        return this.createBorderlessButton(parent, (Supplier<Component>)null);
    }

    public GuiButton createBorderlessButton(@NotNull GuiParent<?> parent, Component label) {
        return this.createBorderlessButton(parent, () -> label);
    }

    public GuiButton createBorderlessButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> label) {
        GuiButton button = new GuiButton(parent);
        GuiTexture texture = new GuiTexture((GuiParent)button, () -> BCGuiTextures.getThemed("button_borderless" + (button.isPressed() ? "_invert" : ""))).dynamicTexture();
        GuiRectangle highlight = new GuiRectangle((GuiParent)button).border(() -> button.hoverTime() > 0 ? -1 : 0);
        Constraints.bind((ConstrainedGeometry)texture, (ConstrainedGeometry)button);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)button);
        if (label != null) {
            Window window = parent.mc().m_91268_();
            double xp = (float)window.m_85445_() / (float)window.m_85441_();
            double yp = (float)window.m_85446_() / (float)window.m_85442_();
            button.setLabel((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, label).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), () -> button.isPressed() ? -0.5 - xp : -0.5).precise())).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), () -> button.isPressed() ? 1.5 - yp : 1.5).precise())).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.WIDTH), (double)-3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.HEIGHT))));
        }
        return button;
    }

    public GuiText playerInvTitle(GuiElement<?> slotsContainer) {
        GuiText title = (GuiText)((GuiText)new GuiText(slotsContainer, (Component)GuiToolkit.translateInternal("your_inventory")).setAlignment(Align.LEFT).setTextColour(Palette.BG::text).setShadow(() -> BCConfig.darkMode).constrain(GeoParam.WIDTH, (Constraint)Constraint.match((GeoRef)slotsContainer.get(GeoParam.WIDTH)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        Constraints.placeInside((ConstrainedGeometry)title, slotsContainer, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)-11.0);
        return title;
    }

    public GuiText createHeading(@NotNull GuiParent<?> parent, Component heading, boolean layout) {
        GuiText guiText = new GuiText(parent, heading);
        guiText.setTextColour(Palette.BG::text);
        guiText.setShadow(() -> BCConfig.darkMode);
        if (layout) {
            guiText.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)parent.get(GeoParam.TOP), (double)4.0));
            guiText.constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)parent.get(GeoParam.LEFT)));
            guiText.constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)parent.get(GeoParam.RIGHT)));
            guiText.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        }
        return guiText;
    }

    public GuiText createHeading(@NotNull GuiParent<?> parent, Component heading) {
        return this.createHeading(parent, heading, false);
    }

    public ShaderEnergyBar.EnergyBar createEnergyBar(@NotNull GuiParent<?> parent, @Nullable IOPStorage storage) {
        Supplier<Integer> dark = () -> BCConfig.darkMode ? -8355712 : -11513776;
        GuiRectangle container = new GuiRectangle(parent).setShadeTopLeft(dark).setShadeBottomRight(() -> -1).setShadeCorners(() -> GuiRender.midColour((int)-1, (int)((Integer)dark.get())));
        ShaderEnergyBar energyBar = new ShaderEnergyBar((GuiParent<?>)container);
        energyBar.setToolTipFormatter(ShaderEnergyBar.opEnergyFormatter(storage));
        energyBar.bindOpStorage(storage);
        Constraints.bind((ConstrainedGeometry)energyBar, (ConstrainedGeometry)container, (double)1.0);
        return new ShaderEnergyBar.EnergyBar(container, energyBar);
    }

    public GuiTexture energySlotArrow(@NotNull GuiParent<?> parent, boolean chargeItem, boolean bellowBar) {
        return (GuiTexture)((GuiTexture)new GuiTexture(parent, BCGuiTextures.get("item_charge/" + (bellowBar ? "vertical" : "right") + "_" + (chargeItem ? "charge" : "discharge"))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)(bellowBar ? 12.0 : 14.0)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(bellowBar ? 10.0 : 14.0)));
    }

    public VanillaBar vanillaScrollBar(GuiElement<?> parent, Axis axis) {
        GuiTexture barBg = new GuiTexture(parent, BCGuiTextures.themedGetter("button_disabled")).dynamicTexture();
        GuiSlider scrollBar = new GuiSlider((GuiParent)barBg, axis);
        Constraints.bind((ConstrainedGeometry)scrollBar, (ConstrainedGeometry)barBg, (double)1.0);
        scrollBar.installSlider((GuiElement)GuiRectangle.planeButton((GuiParent)scrollBar)).bindSliderLength().bindSliderWidth();
        GuiRectangle sliderHighlight = (GuiRectangle)new GuiRectangle((GuiParent)scrollBar.getSlider()).fill(1342224127).setEnabled(() -> scrollBar.getSlider().isMouseOver());
        Constraints.bind((ConstrainedGeometry)sliderHighlight, (ConstrainedGeometry)scrollBar.getSlider());
        return new VanillaBar(barBg, scrollBar, sliderHighlight);
    }

    public GuiRectangle embossBorder(@NotNull GuiParent<?> parent) {
        return this.embossBorder(parent, false);
    }

    public GuiRectangle embossBorder(@NotNull GuiParent<?> parent, boolean invert) {
        GuiRectangle border = new GuiRectangle(parent).setShadeBottomRight(() -> invert ? Palette.BG.accentLight() : Palette.BG.accentDark()).setShadeTopLeft(() -> invert ? Palette.BG.accentDark() : Palette.BG.accentLight()).setShadeCorners(Palette.BG::fill).fill(0);
        Constraints.bind((ConstrainedGeometry)GuiRectangle.vanillaSlot((GuiParent)border).setShadeBottomRight(() -> invert ? Palette.BG.accentDark() : Palette.BG.accentLight()).setShadeTopLeft(() -> invert ? Palette.BG.accentLight() : Palette.BG.accentDark()).setShadeCorners(Palette.BG::fill).fill(0), (ConstrainedGeometry)border, (double)1.0);
        return border;
    }

    public GuiRectangle debossBorder(@NotNull GuiParent<?> parent) {
        return this.embossBorder(parent, true);
    }

    public GuiRectangle shadedBorder(@NotNull GuiParent<?> parent) {
        return this.shadedBorder(parent, false);
    }

    public GuiRectangle shadedBorder(@NotNull GuiParent<?> parent, boolean invert) {
        return new GuiRectangle(parent).setShadeBottomRight(() -> invert ? Palette.BG.accentDark() : Palette.BG.accentLight()).setShadeTopLeft(() -> invert ? Palette.BG.accentLight() : Palette.BG.accentDark()).setShadeCorners(Palette.BG::fill).fill(0);
    }

    public GuiElement<?> floatingHeading(ModularGui gui) {
        return this.floatingHeading(gui.getRoot(), gui.getGuiTitle());
    }

    public GuiElement<?> floatingHeading(@NotNull GuiElement<?> parent, Component heading) {
        GuiManipulable titleMovable = new GuiManipulable(parent).addMoveHandle(13).enableCursors(true);
        Constraints.size((ConstrainedGeometry)titleMovable, () -> (double)parent.font().m_92852_((FormattedText)heading) + 10.0, () -> 13.0);
        GuiRectangle titleBackground = new GuiRectangle((GuiParent)titleMovable.getContentElement()).fill(Integer.MIN_VALUE);
        Constraints.bind((ConstrainedGeometry)titleBackground, (ConstrainedGeometry)titleMovable.getContentElement());
        Constraints.bind((ConstrainedGeometry)this.createHeading((GuiParent<?>)titleBackground, heading).setTextColour(14668243), (ConstrainedGeometry)titleBackground);
        return titleMovable;
    }

    public GuiButton createButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> text, boolean inset3d, int doubleBoarder) {
        GuiButton button = new GuiButton(parent);
        if (inset3d) {
            GuiRectangle border = new GuiRectangle((GuiParent)button).borderWidth((double)doubleBoarder).border(() -> Palette.Ctrl.border3D(button.isMouseOver()));
            GuiRectangle background = new GuiRectangle((GuiParent)button).fill(() -> Palette.Ctrl.fill(button.isMouseOver() || button.isPressed())).setShadeTopLeft(() -> button.isPressed() ? Palette.Ctrl.accentDark(true) : Palette.Ctrl.accentLight(button.isMouseOver())).setShadeBottomRight(() -> button.isPressed() ? Palette.Ctrl.accentLight(true) : Palette.Ctrl.accentDark(button.isMouseOver()));
            GuiTexture disabledBG = ((GuiTexture)new GuiTexture((GuiParent)button, BCGuiTextures.themedGetter("button_disabled")).setEnabled(() -> ((GuiButton)button).isDisabled())).dynamicTexture();
            Constraints.bind((ConstrainedGeometry)border, (ConstrainedGeometry)button);
            Constraints.bind((ConstrainedGeometry)disabledBG, (ConstrainedGeometry)button);
            Constraints.bind((ConstrainedGeometry)background, (ConstrainedGeometry)button, (double)doubleBoarder);
        } else {
            GuiRectangle border = new GuiRectangle((GuiParent)button).fill(() -> Palette.Ctrl.fill(button.isMouseOver())).border(() -> Palette.Ctrl.border(button.isMouseOver()));
            Constraints.bind((ConstrainedGeometry)border, (ConstrainedGeometry)button);
        }
        if (text != null) {
            button.setLabel(new GuiText((GuiParent)button, text).setTextColour(() -> button.isDisabled() ? 0xA0A0A0 : Palette.Ctrl.textH(button.isMouseOver())));
            Constraints.bind((ConstrainedGeometry)button.getLabel(), (ConstrainedGeometry)button, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        }
        return button;
    }

    public GuiButton createButton(@NotNull GuiParent<?> parent, @Nullable Supplier<Component> text) {
        return this.createButton(parent, text, true, 1);
    }

    public GuiTextField.TextField createTextField(@NotNull GuiElement<?> parent) {
        GuiRectangle bg = new GuiRectangle(parent);
        bg.rectangle(() -> Palette.Ctrl.fill(bg.isMouseOver()), () -> Palette.Ctrl.accentLight(false));
        GuiTextField textField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField((GuiParent)bg).setTextColor(Palette.Ctrl::text).setShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.RIGHT), (double)-4.0));
        return new GuiTextField.TextField(bg, textField);
    }

    public void jeiExclude(GuiElement<?> element) {
    }

    public Predicate<String> catchyValidator(Predicate<String> predicate) {
        return s -> {
            try {
                return predicate.test((String)s);
            }
            catch (Throwable e) {
                return false;
            }
        };
    }

    public record VanillaBar(GuiTexture container, GuiSlider slider, GuiRectangle highlight) {
    }

    public static abstract class Palette {

        public static class Ctrl {
            public static int fill(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -12100758 : -10191953;
                }
                return BCConfig.darkMode ? -10790053 : -8355712;
            }

            public static int border(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -5721887 : -16777216;
                }
                return BCConfig.darkMode ? -2894893 : -16777216;
            }

            public static int border3D(boolean hovering) {
                return -16777216;
            }

            public static int accentLight(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -9066302 : -5722143;
                }
                return BCConfig.darkMode ? -5723992 : -1;
            }

            public static int accentDark(boolean hovering) {
                if (hovering) {
                    return BCConfig.darkMode ? -14602177 : -11445622;
                }
                return BCConfig.darkMode ? -13619152 : -11184811;
            }

            public static int text() {
                return BCConfig.darkMode ? 14803941 : 0xFFFFFF;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0xFFFFA0 : 0xFFFFA0) : Ctrl.text();
            }
        }

        public static class SubItem {
            public static int fill() {
                return BCConfig.darkMode ? -10592410 : -4340017;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -8947585 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -12171442 : -11905184;
            }

            public static int text() {
                return BCConfig.darkMode ? 14606562 : 1974290;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0 : 0) : SubItem.text();
            }

            public static int border3d() {
                return BCConfig.darkMode ? -1 : -16777216;
            }
        }

        public static class Slot {
            public static int fill() {
                return BCConfig.darkMode ? -9803158 : -7631989;
            }

            public static int border3D(boolean hovering) {
                return BCConfig.darkMode ? -1 : -16777216;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -3947581 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -14013910 : -13158601;
            }

            public static int text() {
                return BCConfig.darkMode ? 14606562 : 1974311;
            }

            public static int textH(boolean hovering) {
                return hovering ? (BCConfig.darkMode ? 0 : 0) : Slot.text();
            }
        }

        public static class BG {
            public static int fill() {
                return BCConfig.darkMode ? -12829636 : -3750202;
            }

            public static int border() {
                return BCConfig.darkMode ? -15461356 : -16777216;
            }

            public static int accentLight() {
                return BCConfig.darkMode ? -10790053 : -1;
            }

            public static int accentDark() {
                return BCConfig.darkMode ? -14145496 : -11184811;
            }

            public static int text() {
                return BCConfig.darkMode ? 11514291 : 0x111111;
            }
        }
    }
}

