/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry.soil;

import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.base.RecipeData;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SoilInfo
extends RecipeData {
    private final ResourceLocation id;
    public Ingredient ingredient;
    public BlockState blockState;
    public FluidState fluidState;
    public ResourceLocation soilTexture;
    public float tickModifier;
    public Set<String> tags;
    public SoilType soilType;

    public SoilInfo(ResourceLocation id, Ingredient ingredient, BlockState blockState, float tickModifier) {
        this.id = id;
        this.ingredient = ingredient;
        this.blockState = blockState;
        this.tickModifier = tickModifier;
        this.tags = new HashSet<String>();
        this.soilType = SoilType.BLOCK;
    }

    public SoilInfo(ResourceLocation id, Ingredient ingredient, FluidState fluidState, float tickModifier) {
        this.id = id;
        this.ingredient = ingredient;
        this.fluidState = fluidState;
        this.tickModifier = tickModifier;
        this.tags = new HashSet<String>();
        this.soilType = SoilType.FLUID;
    }

    public SoilInfo(ResourceLocation id, Ingredient ingredient, ResourceLocation soilTexture, float tickModifier) {
        this.id = id;
        this.ingredient = ingredient;
        this.soilTexture = soilTexture;
        this.tickModifier = tickModifier;
        this.tags = new HashSet<String>();
        this.soilType = SoilType.TEXTURE;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean isValidTag(String tag) {
        return this.tags.contains(tag);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.SOIL_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registration.RECIPE_TYPE_SOIL.get();
    }

    public float getTickModifier() {
        return this.tickModifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof SoilInfo)) return false;
        SoilInfo other = (SoilInfo)((Object)o);
        if (other.soilType != this.soilType) return false;
        if (!other.id.equals((Object)this.id)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.soilType});
    }

    public static enum SoilType {
        BLOCK,
        FLUID,
        TEXTURE;

    }
}

