/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.libnonymous.base.BaseLanguageProvider;
import com.davenonymous.libnonymous.helper.Translatable;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class BonsaiUpgradeWrapper {
    List<ItemStack> upgradeItems;
    List<TagKey<Item>> upgradeItemTags;
    Translatable upgradeDescription;

    public BonsaiUpgradeWrapper(Translatable upgradeDescription, ItemStack ... upgradeItem) {
        this.upgradeItems = Arrays.stream(upgradeItem).toList();
        this.upgradeDescription = upgradeDescription;
    }

    public BonsaiUpgradeWrapper(Translatable upgradeDescription, List<ItemStack> upgradeItems) {
        this.upgradeItems = upgradeItems;
        this.upgradeDescription = upgradeDescription;
    }

    public BonsaiUpgradeWrapper(Translatable upgradeDescription, TagKey<Item> ... upgradeTags) {
        this.upgradeItemTags = Arrays.stream(upgradeTags).toList();
        this.upgradeDescription = upgradeDescription;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        IRecipeSlotBuilder upgradeSlot = builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1);
        if (this.upgradeItemTags != null) {
            for (TagKey<Item> item : this.upgradeItemTags) {
                upgradeSlot.addIngredients(Ingredient.m_204132_(item));
            }
            return;
        }
        upgradeSlot.addItemStacks(this.upgradeItems);
    }

    public void draw(IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        String text = I18n.m_118938_((String)BaseLanguageProvider.getTranslatableLanguageKey((Translatable)this.upgradeDescription), (Object[])new Object[0]);
        List split = font.m_92865_().m_92432_(text, 120, Style.f_131099_);
        int yOffset = 0;
        if (split.size() == 1) {
            yOffset = 5;
        } else if (split.size() == 2) {
            yOffset = 1;
        } else if (split.size() == 3) {
            yOffset = -3;
        }
        for (FormattedText line : split) {
            guiGraphics.m_280488_(mc.f_91062_, line.getString(), 24, yOffset, 0xFFFFFF);
            yOffset += 9;
        }
    }
}

