/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.bonsaitrees3.client.TreeModelRenderer;
import com.davenonymous.bonsaitrees3.client.TreeModels;
import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.libnonymous.render.MultiBlockBlockAndTintGetter;
import com.davenonymous.libnonymous.render.MultiBlockBlockColors;
import com.davenonymous.libnonymous.render.MultiblockBakedModel;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.davenonymous.libnonymous.utils.TickTimeHelper;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;

public class BonsaiRecipeWrapper
implements IRecipeSlotTooltipCallback {
    SaplingInfo sapling;
    public Map<String, SaplingDrop> slotDrops;
    public Map<ResourceLocation, Float> tickModifiers;
    public static ITickTimer tickTimer = null;

    public BonsaiRecipeWrapper(SaplingInfo sapling) {
        this.sapling = sapling;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setSlotName("sapling").addTooltipCallback((IRecipeSlotTooltipCallback)this).addItemStacks(Arrays.stream(this.sapling.ingredient.m_43908_()).toList());
        this.tickModifiers = new HashMap<ResourceLocation, Float>();
        ArrayList<ItemStack> soilStacks = new ArrayList<ItemStack>();
        for (SoilInfo soil : SoilCompatibility.INSTANCE.getValidSoilsForSapling(this.sapling)) {
            ItemStack representation = soil.ingredient.m_43908_()[0];
            this.tickModifiers.put(ForgeRegistries.ITEMS.getKey((Object)representation.m_41720_()), Float.valueOf(soil.getTickModifier()));
            soilStacks.add(representation);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 20).setSlotName("soil").addTooltipCallback((IRecipeSlotTooltipCallback)this).addItemStacks(soilStacks);
        this.slotDrops = new HashMap<String, SaplingDrop>();
        int targetSlot = 0;
        for (int slot = 0; slot < this.sapling.drops.size(); ++slot) {
            SaplingDrop drop = this.sapling.drops.get(slot);
            if (drop.requiresBees && !((Boolean)CommonConfig.enablePollinatingUpgrade.get()).booleanValue()) continue;
            ItemStack dropStack = drop.resultStack.m_41777_();
            dropStack.m_41764_(drop.rolls);
            this.slotDrops.put("output_" + targetSlot, drop);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 81 + 19 * (targetSlot % 4), 1 + 19 * (targetSlot / 4)).setSlotName("output_" + targetSlot).addTooltipCallback((IRecipeSlotTooltipCallback)this).addItemStack(dropStack);
            ++targetSlot;
        }
    }

    public void draw(IRecipeSlotsView view, GuiGraphics stack, double mouseX, double mouseY, IGuiHelper guiHelper) {
        IDrawableStatic slotDrawable = guiHelper.getSlotDrawable();
        slotDrawable.draw(stack, 0, 0);
        slotDrawable.draw(stack, 0, 19);
        for (int i = 0; i < 8; ++i) {
            slotDrawable.draw(stack, 80 + 19 * (i % 4), 19 * (i / 4));
        }
        this.drawBonsai(stack);
    }

    private void drawBonsai(GuiGraphics guiGraphics) {
        MultiblockBlockModel model = TreeModels.get(this.sapling.m_6423_());
        if (model == null) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(50.0f, 20.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(36.0f, 36.0f, 36.0f);
        float scale = (float)model.getScaleRatio(true);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280168_().m_252781_(new Quaternionf(new AxisAngle4f((float)Math.toRadians(155.0), 1.0f, 0.0f, 0.0f)));
        if (tickTimer != null) {
            guiGraphics.m_280168_().m_252781_(new Quaternionf(new AxisAngle4f((float)Math.toRadians(tickTimer.getValue()), 0.0f, 1.0f, 0.0f)));
        }
        guiGraphics.m_280168_().m_252880_((float)(model.width + 1) / -2.0f, (float)(model.height + 1) / -2.0f, (float)(model.depth + 1) / -2.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        GL11.glFrontFace((int)2304);
        Minecraft mc = Minecraft.m_91087_();
        MultiblockBakedModel baked = MultiblockBakedModel.of((MultiblockBlockModel)model);
        MultiBlockBlockAndTintGetter fakeLevel = new MultiBlockBlockAndTintGetter(model, (BlockAndTintGetter)mc.f_91073_, BlockPos.f_121853_);
        TreeModelRenderer mr = new TreeModelRenderer((BlockColors)new MultiBlockBlockColors(model));
        if (((GraphicsStatus)mc.f_91066_.m_232060_().m_231551_()).m_35965_() >= GraphicsStatus.FANCY.m_35965_()) {
            mr.tesselateWithAO((BlockAndTintGetter)fakeLevel, (BakedModel)baked, Blocks.f_50054_.m_49966_(), BlockPos.f_121853_, guiGraphics.m_280168_(), buffer, true, mc.f_91073_.f_46441_, 0L, 15, ModelData.EMPTY, RenderType.m_110463_());
        } else {
            mr.tesselateWithoutAO((BlockAndTintGetter)fakeLevel, (BakedModel)baked, Blocks.f_50054_.m_49966_(), BlockPos.f_121853_, guiGraphics.m_280168_(), buffer, true, mc.f_91073_.f_46441_, 0L, 192, ModelData.EMPTY, RenderType.m_110463_());
        }
        bufferSource.m_109911_();
        GL11.glFrontFace((int)2305);
        guiGraphics.m_280168_().m_85849_();
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
        if (recipeSlotView.isEmpty() || recipeSlotView.getSlotName().isEmpty()) {
            return;
        }
        String slotName = (String)recipeSlotView.getSlotName().get();
        if (recipeSlotView.getRole() == RecipeIngredientRole.INPUT) {
            ResourceLocation rLoc;
            float tickModifier;
            String timeToGrow;
            MutableComponent toAdd;
            String timeToGrow2;
            MutableComponent toAdd2;
            if (slotName.equals("sapling") && !tooltip.contains(toAdd2 = Component.m_237110_((String)"jei.bonsaitrees3.growtime", (Object[])new Object[]{timeToGrow2 = TickTimeHelper.getDuration((int)this.sapling.baseTicks)}).m_130940_(ChatFormatting.YELLOW))) {
                tooltip.add(tooltip.size() - 1, (Component)toAdd2);
            }
            if (slotName.equals("soil") && !tooltip.contains(toAdd = Component.m_237110_((String)"jei.bonsaitrees3.soiltime", (Object[])new Object[]{timeToGrow = TickTimeHelper.getDuration((int)((int)((float)this.sapling.baseTicks * (tickModifier = this.tickModifiers.getOrDefault(rLoc = ForgeRegistries.ITEMS.getKey((Object)recipeSlotView.getDisplayedItemStack().orElse(ItemStack.f_41583_).m_41720_()), Float.valueOf(1.0f)).floatValue()))))}).m_130940_(ChatFormatting.YELLOW))) {
                tooltip.add(tooltip.size() - 1, (Component)toAdd);
            }
        } else if (this.slotDrops.containsKey(slotName)) {
            MutableComponent toAdd;
            SaplingDrop drop = this.slotDrops.get(slotName);
            if (((Boolean)CommonConfig.showChanceInJEI.get()).booleanValue() && !tooltip.contains(toAdd = Component.m_237110_((String)"jei.bonsaitrees3.chance", (Object[])new Object[]{(int)(drop.chance * 100.0f)}).m_130940_(ChatFormatting.YELLOW))) {
                tooltip.add(tooltip.size() - 1, (Component)toAdd);
            }
            if (drop.requiresSilkTouch && !tooltip.contains(toAdd = Component.m_237115_((String)"jei.bonsaitrees3.requiresSilkTouch").m_130940_(ChatFormatting.RED))) {
                tooltip.add(tooltip.size() - 1, (Component)toAdd);
            }
            if (drop.requiresBees && !tooltip.contains(toAdd = Component.m_237115_((String)"jei.bonsaitrees3.requiresBees").m_130940_(ChatFormatting.RED))) {
                tooltip.add(tooltip.size() - 1, (Component)toAdd);
            }
            if (!drop.requiredUpgrades.m_43947_() && !tooltip.contains(toAdd = Component.m_237115_((String)"jei.bonsaitrees3.requiresUpgrade").m_130940_(ChatFormatting.RED))) {
                ItemStack[] items;
                tooltip.add(tooltip.size() - 1, (Component)toAdd);
                for (ItemStack item : items = drop.requiredUpgrades.m_43908_()) {
                    Component name = item.m_41720_().m_7626_(item);
                    MutableComponent itemLine = Component.m_237113_((String)("- " + name.getString())).m_130940_(ChatFormatting.AQUA);
                    tooltip.add(tooltip.size() - 1, (Component)itemLine);
                }
            }
        }
    }
}

