/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.client.TreeModelRenderer;
import com.davenonymous.bonsaitrees3.client.TreeModels;
import com.davenonymous.bonsaitrees3.config.ClientConfig;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.libnonymous.render.MultiBlockBlockAndTintGetter;
import com.davenonymous.libnonymous.render.MultiBlockBlockColors;
import com.davenonymous.libnonymous.render.MultiblockBakedModel;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;

public class BonsaiPotRenderer
implements BlockEntityRenderer<BonsaiPotBlockEntity> {
    public static final ResourceLocation WATER = new ResourceLocation("minecraft", "block/water_still");

    public BonsaiPotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BonsaiPotBlockEntity pPotBlock, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pPotBlock.hasSapling() || !pPotBlock.hasSoil()) {
            return;
        }
        if (pPotBlock.m_58904_() == null) {
            return;
        }
        SaplingInfo saplingInfo = pPotBlock.getSaplingInfo();
        if (saplingInfo == null) {
            return;
        }
        Boolean renderItemInstead = (Boolean)ClientConfig.alwaysRenderAsItem.get();
        MultiblockBlockModel multiBlock = TreeModels.get(saplingInfo.m_6423_());
        if (multiBlock == null) {
            renderItemInstead = true;
        }
        float scaleRatio = 1.0f;
        if (!renderItemInstead.booleanValue()) {
            scaleRatio = (float)multiBlock.getScaleRatio(true);
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.1f, 0.5f);
        poseStack.m_85841_(scaleRatio, scaleRatio, scaleRatio);
        float maxSize = 0.9f;
        poseStack.m_85841_(maxSize, maxSize, maxSize);
        float progress = (float)pPotBlock.getProgress(pPartialTick);
        poseStack.m_85841_(progress, progress, progress);
        RenderType rendertype = RenderType.m_110463_();
        Minecraft mc = Minecraft.m_91087_();
        if (((GraphicsStatus)mc.f_91066_.m_232060_().m_231551_()).m_35965_() == GraphicsStatus.FAST.m_35965_()) {
            rendertype = RenderType.m_110451_();
        }
        if (renderItemInstead.booleanValue()) {
            Block blockToRender;
            if (saplingInfo.ingredient != null && saplingInfo.ingredient.m_43908_().length > 0 && (blockToRender = Block.m_49814_((Item)saplingInfo.ingredient.m_43908_()[0].m_41720_())) != Blocks.f_50016_) {
                poseStack.m_85841_(maxSize, maxSize, maxSize);
                poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
                mc.m_91289_().renderSingleBlock(blockToRender.m_49966_(), poseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, rendertype);
            }
        } else {
            double rotate = Math.toRadians((float)pPotBlock.modelRotation * 90.0f);
            poseStack.m_252781_(new Quaternionf(new AxisAngle4f((float)rotate, 0.0f, 1.0f, 0.0f)));
            float translateOffsetX = (float)(multiBlock.width + 1) / 2.0f;
            float translateOffsetY = 0.0f;
            float translateOffsetZ = (float)(multiBlock.depth + 1) / 2.0f;
            poseStack.m_252880_(-translateOffsetX, -translateOffsetY, -translateOffsetZ);
            VertexConsumer buffer = pBufferSource.m_6299_(rendertype);
            MultiblockBakedModel baked = MultiblockBakedModel.of((MultiblockBlockModel)multiBlock);
            MultiBlockBlockAndTintGetter fakeLevel = new MultiBlockBlockAndTintGetter(multiBlock, (BlockAndTintGetter)pPotBlock.m_58904_(), pPotBlock.m_58899_());
            TreeModelRenderer mr = new TreeModelRenderer((BlockColors)new MultiBlockBlockColors(multiBlock));
            if (((GraphicsStatus)mc.f_91066_.m_232060_().m_231551_()).m_35965_() >= GraphicsStatus.FANCY.m_35965_()) {
                mr.tesselateWithAO((BlockAndTintGetter)fakeLevel, (BakedModel)baked, pPotBlock.m_58900_(), pPotBlock.m_58899_(), poseStack, buffer, true, pPotBlock.m_58904_().f_46441_, 0L, pPackedLight, ModelData.EMPTY, rendertype);
            } else {
                mr.tesselateWithoutAO((BlockAndTintGetter)fakeLevel, (BakedModel)baked, pPotBlock.m_58900_(), pPotBlock.m_58899_(), poseStack, buffer, true, pPotBlock.m_58904_().f_46441_, 0L, pPackedLight, ModelData.EMPTY, rendertype);
            }
        }
        poseStack.m_85849_();
    }
}

