/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.blocks;

import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingRecipeHelper;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilRecipeHelper;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.base.BaseBlockEntity;
import com.davenonymous.libnonymous.helper.EnchantmentHelper;
import com.davenonymous.libnonymous.helper.InventoryHelper;
import com.davenonymous.libnonymous.helper.RedstoneMode;
import com.davenonymous.libnonymous.helper.SpawnHelper;
import com.davenonymous.libnonymous.serialization.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class BonsaiPotBlockEntity
extends BaseBlockEntity<BonsaiPotBlockEntity> {
    private SoilInfo soilInfo = null;
    private SaplingInfo saplingInfo = null;
    @Store(sendInUpdatePackage=true)
    public int modelRotation = -1;
    @Store(sendInUpdatePackage=true)
    protected int growTicks;
    @Store(sendInUpdatePackage=true)
    protected int requiredTicks;
    @Store(sendInUpdatePackage=true)
    public RedstoneMode redstoneMode = RedstoneMode.IGNORE_POWER;
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler soilItemStacks = this.createSoilInputItemHandler();
    private final LazyOptional<IItemHandler> soilItemStackHandler = LazyOptional.of(() -> this.soilItemStacks);
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler saplingItemStacks = this.createSaplingInputItemHandler();
    @Store
    private final ItemStackHandler outputItemStacks = this.createOutputItemHandler();
    private final LazyOptional<IItemHandler> outputItemStackHandler = LazyOptional.of(() -> this.outputItemStacks);
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler upgradeItemStacks = this.createUpgradesItemHandler();
    private final LazyOptional<IItemHandler> upgradeItemStackHandler = LazyOptional.of(() -> this.upgradeItemStacks);
    private final LazyOptional<IItemHandler> combinedItemStackHandler = LazyOptional.of(this::createCombinedItemHandler);
    private boolean autoCut = false;
    private boolean hopping = false;
    private boolean hasSilkTouch = false;
    private boolean hasBeeHive = false;
    private int fortune = 0;
    private int efficiency = 0;
    private List<ItemStack> energyUpgrades = new ArrayList<ItemStack>();
    private int hoppingCooldown = 0;
    private int cuttingCooldown = 0;
    private boolean canSaplingGrow = false;
    public static final ModelProperty<BlockState> SOIL_BLOCK = new ModelProperty();
    public static final ModelProperty<FluidState> FLUID_BLOCK = new ModelProperty();
    public static final ModelProperty<ResourceLocation> SOIL_TEXTURE = new ModelProperty();

    public BonsaiPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BONSAI_POT_BLOCKENTITY.get(), pos, state);
    }

    protected void initialize() {
        super.initialize();
        if (this.m_58904_() == null) {
            return;
        }
        this.updateSaplingInfo();
        this.updateSoilBlock();
        this.updateModules();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.modelRotation == -1) {
            this.modelRotation = this.f_58857_.f_46441_.m_188503_(4);
        }
    }

    public void tickBoth() {
        super.tickBoth();
        this.updateInfoObjects();
        this.updateGrowth();
    }

    public void tickServer() {
        super.tickServer();
        this.hopOutput();
    }

    public void hopOutput() {
        if (!this.hopping) {
            return;
        }
        if (this.hoppingCooldown > 0) {
            --this.hoppingCooldown;
            return;
        }
        IItemHandler belowHandler = this.getNeighborInventory(Direction.DOWN);
        if (belowHandler == null) {
            return;
        }
        boolean changed = false;
        for (int slot = 0; slot < this.outputItemStacks.getSlots(); ++slot) {
            ItemStack simulatedReturnStack;
            ItemStack stack = this.outputItemStacks.getStackInSlot(slot);
            if (stack.m_41619_() || (simulatedReturnStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)stack, (boolean)true)).equals(stack, false)) continue;
            ItemStack returnStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)stack, (boolean)false);
            this.outputItemStacks.setStackInSlot(slot, returnStack.m_41777_());
            changed = true;
        }
        if (changed) {
            this.m_6596_();
            this.notifyClients(false);
        } else {
            this.hoppingCooldown = (Integer)CommonConfig.hoppingCooldown.get();
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(SOIL_BLOCK, (Object)this.getSoilBlock()).with(FLUID_BLOCK, (Object)this.getFluidBlock()).with(SOIL_TEXTURE, (Object)this.getSoilTexture()).build();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(1.0).m_82363_(0.0, 1.0, 0.0);
    }

    public boolean hasSoil() {
        ItemStack soilStack = this.soilItemStacks.getStackInSlot(0);
        return !soilStack.m_41619_();
    }

    private void updateSoilBlock() {
        ItemStack soilStack = this.soilItemStacks.getStackInSlot(0);
        if (soilStack.m_41619_()) {
            this.soilInfo = null;
            this.canSaplingGrow = false;
            return;
        }
        if (this.soilInfo == null || !this.soilInfo.ingredient.test(soilStack)) {
            this.soilInfo = ((SoilRecipeHelper)((Object)Registration.RECIPE_HELPER_SOIL.get())).getSoilForItem(this.m_58904_(), soilStack);
            this.canSaplingGrow = SoilCompatibility.INSTANCE.isReady && SoilCompatibility.INSTANCE.canTreeGrowOnSoil(this.saplingInfo, this.soilInfo);
        }
    }

    public ItemStack setSoil(ItemStack soilStack) {
        ItemStack result = this.soilItemStacks.insertItem(0, soilStack, false);
        this.updateSoilBlock();
        this.updateInfoObjects();
        this.m_6596_();
        this.notifyClients();
        return result;
    }

    public FluidState getFluidBlock() {
        if (this.soilInfo == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.soilInfo.fluidState;
    }

    public BlockState getSoilBlock() {
        if (this.soilInfo == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.soilInfo.blockState;
    }

    public ResourceLocation getSoilTexture() {
        if (this.soilInfo == null) {
            return null;
        }
        return this.soilInfo.soilTexture;
    }

    public SoilInfo getSoilInfo() {
        return this.soilInfo;
    }

    public boolean hasSapling() {
        ItemStack saplingStack = this.saplingItemStacks.getStackInSlot(0);
        return !saplingStack.m_41619_();
    }

    public ItemStack getSapling() {
        return this.saplingItemStacks.getStackInSlot(0);
    }

    private void updateSaplingInfo() {
        ItemStack saplingStack = this.saplingItemStacks.getStackInSlot(0);
        if (saplingStack.m_41619_()) {
            this.saplingInfo = null;
            this.canSaplingGrow = false;
            return;
        }
        if (this.saplingInfo == null || !this.saplingInfo.ingredient.test(saplingStack)) {
            this.saplingInfo = ((SaplingRecipeHelper)((Object)Registration.RECIPE_HELPER_SAPLING.get())).getSaplingInfoForItem(this.m_58904_(), saplingStack);
            this.canSaplingGrow = SoilCompatibility.INSTANCE.isReady && SoilCompatibility.INSTANCE.canTreeGrowOnSoil(this.saplingInfo, this.soilInfo);
        }
    }

    public ItemStack setSapling(ItemStack saplingStack) {
        ItemStack result = this.saplingItemStacks.insertItem(0, saplingStack, false);
        this.updateSaplingInfo();
        this.updateInfoObjects();
        this.growTicks = 0;
        this.modelRotation = this.m_58904_() != null ? this.f_58857_.f_46441_.m_188503_(4) : 0;
        this.m_6596_();
        this.notifyClients();
        return result;
    }

    public SaplingInfo getSaplingInfo() {
        return this.saplingInfo;
    }

    private void updateModules() {
        this.hopping = false;
        this.autoCut = false;
        this.hasSilkTouch = false;
        this.hasBeeHive = false;
        this.fortune = 0;
        this.efficiency = 0;
        this.energyUpgrades.clear();
        for (int slot = 0; slot < this.upgradeItemStacks.getSlots(); ++slot) {
            IEnergyStorage energyCap;
            Optional optEnergyCap;
            ItemStack stack = this.upgradeItemStacks.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            if (stack.m_204117_(Registration.TAG_UPGRADES_POLLINATING)) {
                this.hasBeeHive = (Boolean)CommonConfig.enablePollinatingUpgrade.get();
            }
            if (stack.m_204117_(Registration.TAG_UPGRADES_HOPPING)) {
                this.hopping = (Boolean)CommonConfig.enableHoppingUpgrade.get();
            }
            if (stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG) && (!stack.m_41763_() || stack.m_41773_() < stack.m_41776_())) {
                this.autoCut = (Boolean)CommonConfig.enableAutoCuttingUpgrade.get();
            }
            if (((Boolean)CommonConfig.enableForgeEnergyUpgrade.get()).booleanValue() && (optEnergyCap = stack.getCapability(ForgeCapabilities.ENERGY).resolve()).isPresent() && (energyCap = (IEnergyStorage)optEnergyCap.get()).canExtract()) {
                this.energyUpgrades.add(stack);
            }
            if (!stack.m_41793_() && !(stack.m_41720_() instanceof EnchantedBookItem)) continue;
            EnchantmentHelper enchantmentHelper = new EnchantmentHelper(stack);
            if (((Boolean)CommonConfig.enableFortuneUpgrade.get()).booleanValue()) {
                int level = enchantmentHelper.getLevel(Enchantments.f_44987_);
                int n = this.fortune = (Boolean)CommonConfig.sumEnchantmentLevels.get() != false ? this.fortune + level : Math.max(this.fortune, level);
            }
            if (((Boolean)CommonConfig.enableEfficiencyUpgrade.get()).booleanValue()) {
                int level = enchantmentHelper.getLevel(Enchantments.f_44984_);
                this.efficiency = (Boolean)CommonConfig.sumEnchantmentLevels.get() != false ? this.efficiency + level : Math.max(this.efficiency, level);
            }
            this.hasSilkTouch = this.hasSilkTouch || enchantmentHelper.has(Enchantments.f_44985_);
        }
    }

    protected void updateInfoObjects() {
        if (this.soilInfo != null && this.saplingInfo != null) {
            int ticks = this.saplingInfo.getRequiredTicks();
            float soilModifier = this.soilInfo.getTickModifier();
            this.requiredTicks = (int)Math.ceil((double)((float)ticks * soilModifier) * (Double)CommonConfig.requiredTicksModifier.get());
            if (this.efficiency > 0) {
                float multiplier = (float)Math.min(this.efficiency, 15) * 0.01f;
                this.requiredTicks = (int)((double)this.requiredTicks - Math.ceil((float)this.requiredTicks * multiplier));
            }
            if (this.requiredTicks < (Integer)CommonConfig.minimumRequiredTicks.get()) {
                this.requiredTicks = (Integer)CommonConfig.minimumRequiredTicks.get();
            }
        } else {
            this.requiredTicks = Integer.MAX_VALUE;
        }
    }

    public boolean cutTree(boolean isAutoCut) {
        if (this.saplingInfo == null || this.soilInfo == null) {
            this.updateSaplingInfo();
            this.updateSoilBlock();
            this.updateModules();
            this.updateInfoObjects();
        }
        if (this.saplingInfo == null || this.soilInfo == null || this.m_58904_() == null) {
            return false;
        }
        if (this.growTicks < this.requiredTicks * 1000) {
            return false;
        }
        if (this.m_58904_().m_5776_()) {
            return false;
        }
        boolean hasNeigborSignal = this.m_58904_().m_276867_(this.m_58899_());
        if (this.redstoneMode == RedstoneMode.REQUIRE_POWER && !hasNeigborSignal) {
            return false;
        }
        if (this.redstoneMode == RedstoneMode.REJECT_POWER && hasNeigborSignal) {
            return false;
        }
        List upgradeItems = InventoryHelper.getStacks((ItemStackHandler)this.getUpgradeItemStacks());
        List<ItemStack> drops = this.saplingInfo.getRandomizedDrops(this.f_58857_.f_46441_, this.fortune, this.hasSilkTouch, this.hasBeeHive, upgradeItems);
        IItemHandler belowHandler = null;
        boolean changed = false;
        boolean canHop = this.hopping && (belowHandler = this.getNeighborInventory(Direction.DOWN)) != null;
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack drop;
            ItemStack insertedStack = drop = drops.get(i);
            ItemStack simulatedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputItemStacks, (ItemStack)drop, (boolean)true);
            if (!simulatedStack.equals(drop, false)) {
                insertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputItemStacks, (ItemStack)drop, (boolean)false).m_41777_();
            }
            if (canHop && !insertedStack.m_41619_() && !(simulatedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)insertedStack, (boolean)true)).equals(insertedStack, false)) {
                insertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)insertedStack, (boolean)false).m_41777_();
            }
            changed = changed || !insertedStack.equals(drop, false);
        }
        if (changed && isAutoCut && ((Boolean)CommonConfig.autoCuttingDamagesItems.get()).booleanValue()) {
            boolean shouldTakeDamage;
            boolean bl = shouldTakeDamage = this.f_58857_.f_46441_.m_188500_() <= (Double)CommonConfig.autoCuttingDamageChance.get();
            if (shouldTakeDamage) {
                for (int slotNum = 0; slotNum < this.getUpgradeItemStacks().getSlots(); ++slotNum) {
                    ItemStack stack = this.getUpgradeItemStacks().getStackInSlot(slotNum);
                    if (stack.m_41619_() || !stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG)) continue;
                    if (!stack.m_220157_(1, this.f_58857_.f_46441_, null)) break;
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                    break;
                }
            }
        }
        if (changed) {
            this.setGrowTicks(0);
            this.modelRotation = this.f_58857_.f_46441_.m_188503_(4);
            this.m_6596_();
            this.notifyClients();
        }
        return changed;
    }

    public boolean isGrowing() {
        return this.hasSapling() && this.growTicks < this.requiredTicks * 1000;
    }

    public double getProgress() {
        if (!this.hasSapling() || !this.hasSoil() || this.requiredTicks == 0) {
            return 0.0;
        }
        return (double)this.growTicks / (double)(this.requiredTicks * 1000);
    }

    public double getProgress(float partialTicks) {
        if (!this.hasSapling() || !this.hasSoil() || this.requiredTicks == 0) {
            return 0.0;
        }
        double result = ((double)this.growTicks + (double)partialTicks) / (double)(this.requiredTicks * 1000);
        if (result >= 0.999) {
            result = 1.0;
        }
        return result;
    }

    public void updateGrowth() {
        if (!(this.hasSapling() && this.hasSoil() && this.canSaplingGrow)) {
            this.setGrowTicks(0);
            return;
        }
        if (this.m_58904_() != null && this.getProgress() >= 1.0 && this.autoCut) {
            if (this.cuttingCooldown > 0) {
                --this.cuttingCooldown;
            } else {
                boolean success = this.cutTree(true);
                if (!success) {
                    this.cuttingCooldown = (Integer)CommonConfig.cuttingCooldown.get();
                }
            }
        }
        if (this.getProgress() < 1.0) {
            int rate = 1000;
            for (int i = 0; i < this.energyUpgrades.size(); ++i) {
                int extracted;
                IEnergyStorage energyCap;
                ItemStack upgrade = this.energyUpgrades.get(i);
                Optional optEnergyCap = upgrade.getCapability(ForgeCapabilities.ENERGY).resolve();
                if (!optEnergyCap.isPresent() || !(energyCap = (IEnergyStorage)optEnergyCap.get()).canExtract() || (extracted = energyCap.extractEnergy(((Integer)CommonConfig.maximumExtractedEnergyPerTick.get()).intValue(), true)) <= 0) continue;
                extracted = energyCap.extractEnergy(extracted, false);
                rate = (int)((double)rate * (1.0 + (double)extracted * (Double)CommonConfig.extraGrowthRatioPerFE.get()));
            }
            this.setGrowTicks(this.growTicks + rate);
        }
    }

    public void setGrowTicks(int growTicks) {
        int maxTicks = this.requiredTicks * 1000;
        if (growTicks > maxTicks) {
            growTicks = maxTicks;
        }
        if (growTicks != this.growTicks) {
            this.growTicks = growTicks;
            if (this.growTicks == 0 || this.growTicks == maxTicks) {
                this.m_6596_();
            }
        }
    }

    public void boostProgress() {
        if (!this.isGrowing()) {
            return;
        }
        int limit = this.requiredTicks * 1000;
        this.growTicks += limit / 4;
        if (this.growTicks >= limit) {
            this.growTicks = limit;
        }
        this.notifyClients();
    }

    public void onDataLoaded() {
        if (this.f_58857_ != null) {
            this.updateSaplingInfo();
            this.updateSoilBlock();
            this.updateModules();
            this.updateInfoObjects();
            if (this.f_58857_.f_46443_) {
                this.requestModelDataUpdate();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    public ItemStackHandler getUpgradeItemStacks() {
        return this.upgradeItemStacks;
    }

    public ItemStackHandler getSaplingItemStacks() {
        return this.saplingItemStacks;
    }

    public ItemStackHandler getSoilItemStacks() {
        return this.soilItemStacks;
    }

    public ItemStackHandler getOutputItemStacks() {
        return this.outputItemStacks;
    }

    public static boolean isUpgradeItem(ItemStack stack) {
        IEnergyStorage energyCap;
        LazyOptional optEnergyCap;
        if (((Boolean)CommonConfig.enableHoppingUpgrade.get()).booleanValue() && stack.m_204117_(Registration.TAG_UPGRADES_HOPPING)) {
            return true;
        }
        if (((Boolean)CommonConfig.enablePollinatingUpgrade.get()).booleanValue() && stack.m_204117_(Registration.TAG_UPGRADES_POLLINATING)) {
            return true;
        }
        if (((Boolean)CommonConfig.enableAutoCuttingUpgrade.get()).booleanValue() && stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG)) {
            return true;
        }
        if (stack.m_41793_() || stack.m_41720_() instanceof EnchantedBookItem) {
            EnchantmentHelper enchantments = new EnchantmentHelper(stack);
            if (enchantments.has(Enchantments.f_44985_)) {
                return true;
            }
            if (((Boolean)CommonConfig.enableEfficiencyUpgrade.get()).booleanValue() && enchantments.has(Enchantments.f_44984_)) {
                return true;
            }
            if (((Boolean)CommonConfig.enableFortuneUpgrade.get()).booleanValue() && enchantments.has(Enchantments.f_44987_)) {
                return true;
            }
        }
        if (((Boolean)CommonConfig.enableForgeEnergyUpgrade.get()).booleanValue() && (optEnergyCap = stack.getCapability(ForgeCapabilities.ENERGY)).isPresent() && (energyCap = (IEnergyStorage)optEnergyCap.resolve().get()).canExtract()) {
            return true;
        }
        return SoilCompatibility.INSTANCE.isUpgradeItem(stack);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.combinedItemStackHandler.cast();
            }
            if (side == Direction.UP) {
                return this.upgradeItemStackHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputItemStackHandler.cast();
            }
            return this.soilItemStackHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    private ItemStackHandler createSoilInputItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                SoilInfo soilInfo = ((SoilRecipeHelper)((Object)Registration.RECIPE_HELPER_SOIL.get())).getSoilForItem(BonsaiPotBlockEntity.this.f_58857_, stack);
                return soilInfo != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.updateSoilBlock();
                BonsaiPotBlockEntity.this.updateInfoObjects();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private ItemStackHandler createSaplingInputItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                SaplingInfo saplingInfo = ((SaplingRecipeHelper)((Object)Registration.RECIPE_HELPER_SAPLING.get())).getSaplingInfoForItem(BonsaiPotBlockEntity.this.f_58857_, stack);
                return saplingInfo != null;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                ItemStack previous = this.getStackInSlot(slot);
                if (!ItemStack.m_150942_((ItemStack)previous, (ItemStack)stack)) {
                    BonsaiPotBlockEntity.this.growTicks = 0;
                    BonsaiPotBlockEntity.this.m_6596_();
                    BonsaiPotBlockEntity.this.notifyClients();
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.updateSaplingInfo();
                BonsaiPotBlockEntity.this.updateInfoObjects();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private ItemStackHandler createOutputItemHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
            }
        };
    }

    private ItemStackHandler createUpgradesItemHandler() {
        return new ItemStackHandler(4){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BonsaiPotBlockEntity.isUpgradeItem(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.updateModules();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.soilItemStacks, this.saplingItemStacks, this.upgradeItemStacks}){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    public void dropItemStackContents() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.upgradeItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.outputItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.soilItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.saplingItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
    }
}

