/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.revelationary;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.dafuqs.revelationary.api.advancements.AdvancementUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class Commands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralCommandNode revelationaryNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"revelationary").requires(source -> source.method_9259(4))).build();
        dispatcher.getRoot().addChild((CommandNode)revelationaryNode);
        LiteralCommandNode advancementNode = class_2170.method_9247((String)"advancement").build();
        revelationaryNode.addChild((CommandNode)advancementNode);
        LiteralCommandNode revokeNode = class_2170.method_9247((String)"revoke").build();
        advancementNode.addChild((CommandNode)revokeNode);
        Commands.executesWithTargetsNamespacePathArguments((CommandNode<class_2168>)revokeNode, Executors::revoke);
        LiteralCommandNode grantNode = class_2170.method_9247((String)"grant").build();
        advancementNode.addChild((CommandNode)grantNode);
        Commands.executesWithTargetsNamespacePathArguments((CommandNode<class_2168>)grantNode, Executors::grant);
        LiteralCommandNode syncNode = class_2170.method_9247((String)"sync").build();
        advancementNode.addChild((CommandNode)syncNode);
        ArgumentCommandNode sourceSyncArgument = class_2170.method_9244((String)"source", (ArgumentType)class_2186.method_9305()).build();
        ArgumentCommandNode targetsSyncArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> Executors.sync((CommandContext<class_2168>)context, false, false, false))).build();
        ArgumentCommandNode namespaceSyncArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"namespace", (ArgumentType)StringArgumentType.string()).executes(context -> Executors.sync((CommandContext<class_2168>)context, true, false, false))).build();
        ArgumentCommandNode pathSyncArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> Executors.sync((CommandContext<class_2168>)context, true, true, false))).build();
        ArgumentCommandNode deleteOldSyncArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"deleteOld", (ArgumentType)BoolArgumentType.bool()).executes(context -> Executors.sync((CommandContext<class_2168>)context, true, true, true))).build();
        syncNode.addChild((CommandNode)sourceSyncArgument);
        sourceSyncArgument.addChild((CommandNode)targetsSyncArgument);
        targetsSyncArgument.addChild((CommandNode)namespaceSyncArgument);
        namespaceSyncArgument.addChild((CommandNode)pathSyncArgument);
        pathSyncArgument.addChild((CommandNode)deleteOldSyncArgument);
    }

    private static int retrieveArgumentsAndCallExecutor(CommandContext<class_2168> context, TargetsNamespacePathExecutor executor, boolean checkNamespace, boolean checkPath) throws CommandSyntaxException {
        return executor.execute(context, class_2186.method_9312(context, (String)"targets"), checkNamespace ? StringArgumentType.getString(context, (String)"namespace") : "all", checkPath ? StringArgumentType.getString(context, (String)"path") : "all");
    }

    private static CommandNode<class_2168> executesWithTargetsNamespacePathArguments(CommandNode<class_2168> parentNode, TargetsNamespacePathExecutor executor) {
        ArgumentCommandNode targetsArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> Commands.retrieveArgumentsAndCallExecutor((CommandContext<class_2168>)context, executor, false, false))).build();
        ArgumentCommandNode namespaceArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"namespace", (ArgumentType)StringArgumentType.string()).executes(context -> Commands.retrieveArgumentsAndCallExecutor((CommandContext<class_2168>)context, executor, true, false))).build();
        ArgumentCommandNode pathArgument = ((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.string()).executes(context -> Commands.retrieveArgumentsAndCallExecutor((CommandContext<class_2168>)context, executor, true, true))).build();
        parentNode.addChild((CommandNode)targetsArgument);
        targetsArgument.addChild((CommandNode)namespaceArgument);
        namespaceArgument.addChild((CommandNode)pathArgument);
        return pathArgument;
    }

    private static String joinPlayersList(Collection<class_3222> players) {
        return players.stream().map(player -> player.method_5476().getString()).collect(Collectors.joining(", "));
    }

    @FunctionalInterface
    private static interface TargetsNamespacePathExecutor {
        public int execute(CommandContext<class_2168> var1, Collection<class_3222> var2, String var3, String var4) throws CommandSyntaxException;
    }

    private static class Executors {
        private Executors() {
        }

        private static int revoke(CommandContext<class_2168> context, Collection<class_3222> targets, String namespace, String path) {
            int count = targets.stream().mapToInt(player -> AdvancementUtils.forPlayer(player).withNamespace(namespace).withPath(path).revoke()).sum();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.revelationary.advancement.revoke", (Object[])new Object[]{count, Commands.joinPlayersList(targets), namespace, path}), false);
            return count;
        }

        private static int grant(CommandContext<class_2168> context, Collection<class_3222> targets, String namespace, String path) {
            int count = targets.stream().mapToInt(player -> AdvancementUtils.forPlayer(player).withNamespace(namespace).withPath(path).grant()).sum();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.revelationary.advancement.grant", (Object[])new Object[]{count, Commands.joinPlayersList(targets), namespace, path}), false);
            return count;
        }

        private static int sync(CommandContext<class_2168> context, boolean checkNamespace, boolean checkPath, boolean checkDeleteOld) throws CommandSyntaxException {
            class_3222 source = class_2186.method_9315(context, (String)"source");
            Collection targets = class_2186.method_9312(context, (String)"targets");
            String namespace = checkNamespace ? StringArgumentType.getString(context, (String)"namespace") : "all";
            String path = checkPath ? StringArgumentType.getString(context, (String)"path") : "all";
            boolean deleteOld = checkDeleteOld && BoolArgumentType.getBool(context, (String)"deleteOld");
            int count = targets.stream().mapToInt(player -> AdvancementUtils.forPlayer(source).withNamespace(namespace).withPath(path).syncTo((class_3222)player, deleteOld)).sum();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.revelationary.advancement.sync", (Object[])new Object[]{count, source.method_5476(), Commands.joinPlayersList(targets), namespace, path}), false);
            return count;
        }
    }
}

