/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.Utils;
import com.tagnumelite.projecteintegration.api.recipe.ACustomRecipeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;

@EMCMapper
public class PEIRecipeMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final Map<ACustomRecipeMapper<?>, String> recipeMappers = new HashMap();

    public static void loadMappers() {
        if (recipeMappers.isEmpty()) {
            recipeMappers.putAll(Utils.getCustomRecipeMappers());
        }
    }

    public String getName() {
        return "ProjectEIntegrationRecipeMapper";
    }

    public String getDescription() {
        return "Recipe mapper for custom recipes that don't implement IRecipe";
    }

    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mappingCollector, CommentedFileConfig config, ReloadableServerResources reloadableServerResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        NSSFake.setCurrentNamespace((String)"projecteintegrationRecipeMapper");
        NSSFakeGroupManager fakeGroupManager = new NSSFakeGroupManager();
        for (Map.Entry<ACustomRecipeMapper<?>, String> mapperEntry : recipeMappers.entrySet()) {
            ACustomRecipeMapper<?> recipeMapper = mapperEntry.getKey();
            String modid = mapperEntry.getValue();
            String name = recipeMapper.getName();
            String configKey = this.getName() + "." + name + ".enabled";
            if (!((Boolean)EMCMappingHandler.getOrSetDefault((CommentedFileConfig)config, (String)configKey, (String)recipeMapper.getDescription(), (Object)true)).booleanValue()) continue;
            NSSFakeGroupManager.setNamespace(modid);
            List<?> recipes = recipeMapper.getRecipes();
            for (Object recipe : recipes) {
                try {
                    if (recipeMapper.handleRecipe(mappingCollector, recipe, registryAccess, fakeGroupManager)) continue;
                    PEIntegration.debugLog("Recipe Mapper ({}) failed to handle recipe: {}", name, recipe);
                }
                catch (Exception e) {
                    PEIntegration.LOGGER.error("Custom Recipe Mapper ({}) failed to handle recipe: {}", (Object)name, recipe, (Object)e);
                }
            }
        }
        NSSFake.resetNamespace();
        NSSFakeGroupManager.resetNamespace();
    }

    private static class NSSFakeGroupManager
    implements INSSFakeGroupManager {
        private static String namespace = "";
        private final Map<Set<NormalizedSimpleStack>, NormalizedSimpleStack> groups = new HashMap<Set<NormalizedSimpleStack>, NormalizedSimpleStack>();
        private int fakeIndex;

        private NSSFakeGroupManager() {
        }

        public static void setNamespace(String namespace) {
            NSSFakeGroupManager.namespace = namespace;
        }

        public static void resetNamespace() {
            namespace = "";
        }

        public Tuple<NormalizedSimpleStack, Boolean> getOrCreateFakeGroup(Set<NormalizedSimpleStack> normalizedSimpleStacks) {
            NormalizedSimpleStack stack = this.groups.get(normalizedSimpleStacks);
            if (stack == null) {
                stack = NSSFake.create((String)(namespace + "_" + this.fakeIndex++));
                this.groups.put(new HashSet<NormalizedSimpleStack>(normalizedSimpleStacks), stack);
                return new Tuple((Object)stack, (Object)true);
            }
            return new Tuple((Object)stack, (Object)false);
        }
    }
}

