/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class IndustrialForegoingAddon {
    public static final String MODID = "industrialforegoing";
    public static final RecipeType<CrusherRecipe> crusherRecipeType = (RecipeType)ModuleCore.CRUSHER_TYPE.get();
    public static final RecipeType<DissolutionChamberRecipe> dissolutionChamberRecipeType = (RecipeType)ModuleCore.DISSOLUTION_TYPE.get();
    public static final RecipeType<StoneWorkGenerateRecipe> stoneworkGenerateRecipeType = (RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get();

    public static String NAME(String name) {
        return "IndustrialForegoing" + name + "Mapper";
    }

    @ConversionProvider(value="industrialforegoing")
    public static class IFConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.comment("Sets default conversions for Industrial Foregoing").before((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1L).before((ItemLike)ModuleCore.TINY_DRY_RUBBER.get(), 1L).conversion((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1600)).ingredient(ItemTags.f_13182_)).end().conversion((ItemLike)ModuleCore.FERTILIZER.get())).ingredient((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1000)).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFStoneWorkGenerateMapper
    extends ARecipeTypeMapper<StoneWorkGenerateRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("StoneWorksGenerate");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == stoneworkGenerateRecipeType;
        }

        @Override
        public NSSOutput getOutput(StoneWorkGenerateRecipe recipe) {
            ItemStack output = recipe.output.m_41777_();
            if (output.m_41619_()) {
                return null;
            }
            return new NSSOutput(output);
        }

        @Override
        public NSSInput getInput(StoneWorkGenerateRecipe recipe) {
            int lavaRequired = recipe.lavaConsume;
            int waterRequired = recipe.waterConsume;
            if (lavaRequired == 0 && waterRequired == 0) {
                return null;
            }
            IngredientMap ingredientMap = new IngredientMap();
            if (lavaRequired > 0) {
                ingredientMap.addIngredient((Object)NSSFluid.createFluid((Fluid)Fluids.f_76195_), lavaRequired);
            }
            if (waterRequired > 0) {
                ingredientMap.addIngredient((Object)NSSFluid.createFluid((Fluid)Fluids.f_76193_), waterRequired);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFDissolutionChamberMapper
    extends ARecipeTypeMapper<DissolutionChamberRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("DissolutionChamber");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == dissolutionChamberRecipeType;
        }

        @Override
        public NSSOutput getOutput(DissolutionChamberRecipe recipe) {
            if (!recipe.output.m_41619_() && (recipe.outputFluid == null || recipe.outputFluid.isEmpty())) {
                return super.getOutput(recipe);
            }
            return this.mapOutputs(recipe.output, recipe.outputFluid);
        }

        @Override
        public NSSInput getInput(DissolutionChamberRecipe recipe) {
            return super.getInput(recipe);
        }

        @Override
        protected List<Ingredient> getIngredients(DissolutionChamberRecipe recipe) {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>(recipe.input.length);
            for (Ingredient.Value input : recipe.input) {
                list.add(Ingredient.m_43921_(input.m_6223_().stream()));
            }
            return list;
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFCrusherMapper
    extends ARecipeTypeMapper<CrusherRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("Crusher");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == crusherRecipeType;
        }

        @Override
        public NSSOutput getOutput(CrusherRecipe recipe) {
            return this.mapOutput(recipe.output.m_43908_());
        }

        @Override
        protected List<Ingredient> getIngredients(CrusherRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }
}

