/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import novamachina.exnihilosequentia.world.item.crafting.CrushingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.DropListRecipe;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.PrecipitateRecipe;
import novamachina.exnihilosequentia.world.item.crafting.SiftingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.SolidifyingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.TransitionRecipe;

public class ExNihiloSequentiaAddon {
    public static final String MODID = "exnihilosequentia";

    static String NAME(String name) {
        return "ExNihiloSequentia" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSTransitionMapper
    extends ARecipeTypeMapper<TransitionRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Transition");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.TRANSITION;
        }

        @Override
        public NSSInput getInput(TransitionRecipe recipe) {
            return NSSInput.createFluid(recipe.getFluidInTank());
        }

        @Override
        public NSSOutput getOutput(TransitionRecipe recipe) {
            return new NSSOutput(recipe.getResult());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSSolidifyingMapper
    extends ARecipeTypeMapper<SolidifyingRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Solidifying");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.SOLIDIFYING;
        }

        @Override
        public NSSOutput getOutput(SolidifyingRecipe recipe) {
            return new NSSOutput(recipe.getResult());
        }

        @Override
        public NSSInput getInput(SolidifyingRecipe recipe) {
            return NSSInput.createFluid(recipe.getFluidInTank());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSSiftingMapper
    extends ARecipeTypeMapper<SiftingRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Sifting");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Only maps guaranteed drop, ignore chanced items.";
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.SIFTING;
        }

        @Override
        protected List<Ingredient> getIngredients(SiftingRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(SiftingRecipe recipe) {
            return new NSSOutput(recipe.getDrop());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSPrecipitateMapper
    extends ARecipeTypeMapper<PrecipitateRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Precipitate");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.PRECIPITATE;
        }

        @Override
        public NSSInput getInput(PrecipitateRecipe recipe) {
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            if (!this.convertIngredient(recipe.getInput(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            if (!this.convertFluidIngredient(recipe.getFluid(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(PrecipitateRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSMeltingMapper
    extends ARecipeTypeMapper<MeltingRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Melting");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.MELTING;
        }

        @Override
        protected List<Ingredient> getIngredients(MeltingRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(MeltingRecipe recipe) {
            return new NSSOutput(recipe.getResultFluid());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSCrushingMapper
    extends ENSDropListRecipeMapper<CrushingRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Crushing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == EXNRecipeTypes.CRUSHING;
        }
    }

    public static abstract class ENSDropListRecipeMapper<C extends DropListRecipe>
    extends ARecipeTypeMapper<C> {
        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Skips all items with change less than 100%";
        }

        @Override
        protected List<Ingredient> getIngredients(C recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(C recipe) {
            NSSOutput.Builder builder = NSSOutput.builder((IMappingCollector<NormalizedSimpleStack, Long>)this.mapper, this.fakeGroupManager, this.recipeID);
            for (ItemStackWithChance drop : recipe.getDrops()) {
                if (!(drop.getChance() >= 1.0f)) continue;
                builder.addOutput(drop.getStack());
            }
            if (builder.isEmpty()) {
                return NSSOutput.EMPTY;
            }
            return builder.toOutput();
        }
    }
}

