/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ACustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.CustomRecipeMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BlueSkiesAddon {
    public static final String MODID = "blue_skies";

    public static String NAME(String name) {
        return "BlueSkies" + name + "Mapper";
    }

    @CustomRecipeMapper(value="blue_skies")
    public static class BSAlchemyTableMapper
    extends ACustomRecipeMapper<AlchemyRecipe> {
        @Override
        public String getName() {
            return BlueSkiesAddon.NAME("AlchemyTable");
        }

        @Override
        public List<AlchemyRecipe> getRecipes() {
            return new ArrayList<AlchemyRecipe>(BlueSkiesData.ALCHEMY_RECIPES.getData().values());
        }

        @Override
        protected List<Ingredient> getIngredients(AlchemyRecipe recipe) {
            if (recipe instanceof CatylistRecipe) {
                CatylistRecipe catylistRecipe = (CatylistRecipe)recipe;
                return Arrays.asList(Ingredient.m_43921_(catylistRecipe.getInput().stream().map(ItemStack::new)), Ingredient.m_43921_(catylistRecipe.getCatylist().stream().map(ItemStack::new)));
            }
            if (recipe instanceof TransmuteRecipe) {
                List results = recipe.getResults();
                results.remove(results.size() - 1);
                return Collections.singletonList(Ingredient.m_43929_((ItemLike[])((ItemLike[])results.toArray(new Item[0]))));
            }
            PEIntegration.LOGGER.error("(Blue Skies) | Unsupported AlchemyRecipe: {}", (Object)recipe);
            return null;
        }

        @Override
        protected ItemStack getResult(AlchemyRecipe recipe) {
            if (recipe instanceof CatylistRecipe) {
                return new ItemStack((ItemLike)recipe.getResults().get(0));
            }
            if (recipe instanceof TransmuteRecipe) {
                return new ItemStack((ItemLike)recipe.getResults().get(recipe.getResults().size() - 1));
            }
            PEIntegration.LOGGER.error("(Blue Skies) | Unsupported AlchemyRecipe: {}", (Object)recipe);
            return null;
        }
    }
}

