/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.init.DEDamage;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ProcessChaosImplosion
implements IProcess {
    private Level world;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private float power;
    private Random random = new Random();
    private double expansion = 0.0;
    private boolean isDead = false;

    public ProcessChaosImplosion(Level world, int x, int y, int z) {
        this.world = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.power = 30.0f;
        this.isDead = world.f_46443_;
    }

    public void updateProcess() {
        int OD = (int)this.expansion;
        int ID = OD - 1;
        int size = (int)this.expansion;
        for (int x = this.xCoord - size; x < this.xCoord + size; ++x) {
            for (int z = this.zCoord - size; z < this.zCoord + size; ++z) {
                double dist = Utils.getDistance((double)x, (double)z, (double)this.xCoord, (double)this.zCoord);
                if (!(dist < (double)OD) || !(dist >= (double)ID)) continue;
                float tracePower = this.power - (float)(this.expansion / 10.0);
                tracePower = (float)((double)tracePower * (1.0 + (double)(this.random.nextFloat() - 0.5f) * 0.2));
                ProcessHandler.addProcess((IProcess)new ChaosImplosionTrace(this.world, x, this.yCoord, z, tracePower, this.random));
            }
        }
        this.isDead = this.expansion >= (double)(this.power * 10.0f);
        this.expansion += 1.0;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public class ChaosImplosionTrace
    implements IProcess {
        private Level level;
        private int xCoord;
        private int yCoord;
        private int zCoord;
        private float power;
        private Random random;
        private boolean isDead = false;

        public ChaosImplosionTrace(Level level, int x, int y, int z, float power, Random random) {
            this.level = level;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.power = power;
            this.random = random;
        }

        public void updateProcess() {
            List entities;
            int y;
            float energy = this.power * 10.0f;
            for (y = this.yCoord; y >= 0 && energy > 0.0f; energy -= 0.5f + 0.1f * (float)(this.yCoord - y), --y) {
                entities = this.level.m_45976_(Entity.class, new AABB((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
                for (Entity entity : entities) {
                    entity.m_6469_(DEDamage.chaosImplosion(this.level), this.power * 100.0f);
                }
                if (!(energy >= 0.0f)) continue;
                this.level.m_7471_(new BlockPos(this.xCoord, y, this.zCoord), false);
            }
            energy = this.power * 20.0f;
            ++this.yCoord;
            for (y = this.yCoord; y < 255 && energy > 0.0f; energy -= 0.5f + 0.1f * (float)(y - this.yCoord), ++y) {
                entities = this.level.m_45976_(Entity.class, new AABB((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
                for (Entity entity : entities) {
                    entity.m_6469_(DEDamage.chaosImplosion(this.level), this.power * 100.0f);
                }
                if (!(energy >= 0.0f)) continue;
                this.level.m_7471_(new BlockPos(this.xCoord, y, this.zCoord), false);
            }
            this.isDead = true;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

