/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.projectile;

import com.teamabnormals.savage_and_ravage.common.block.RunedGloomyTilesBlock;
import com.teamabnormals.savage_and_ravage.common.entity.TracksHits;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRMobEffects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;

public class RunePrison
extends Entity {
    private static final EntityDataAccessor<Integer> TICKS_TILL_REMOVE = SynchedEntityData.m_135353_(RunePrison.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> BLOCK_POS = SynchedEntityData.m_135353_(RunePrison.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private final boolean fromTrap;
    private UUID casterUUID = null;
    private int casterID = 0;
    private int currentFrame = 0;
    private boolean isBackwardsFrameCycle = false;

    public RunePrison(EntityType<? extends RunePrison> type, Level world) {
        super(type, world);
        this.fromTrap = false;
    }

    public RunePrison(Level world, BlockPos position, int ticksTillRemove, boolean fromTrap) {
        super((EntityType)SREntityTypes.RUNE_PRISON.get(), world);
        this.setBlockPos(position);
        this.fromTrap = fromTrap;
        this.setTicksTillRemove(ticksTillRemove);
    }

    public <T extends Entity> RunePrison(Level world, BlockPos position, int ticksTillRemove, boolean fromTrap, T caster) {
        this(world, position, ticksTillRemove, fromTrap);
        this.setCaster(caster);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_POS, Optional.empty());
        this.f_19804_.m_135372_(TICKS_TILL_REMOVE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setTicksTillRemove(compound.m_128451_("TicksTillRemove"));
        if (compound.m_128425_("GloomyTilePosition", 10)) {
            this.setBlockPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("GloomyTilePosition")));
        }
        if (compound.m_128403_("CasterUUID")) {
            this.casterUUID = compound.m_128342_("CasterUUID");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBlockPos() != null) {
            compound.m_128365_("GloomyTilePosition", (Tag)NbtUtils.m_129224_((BlockPos)this.getBlockPos()));
        }
        if (this.casterUUID != null) {
            compound.m_128362_("CasterUUID", this.casterUUID);
        }
    }

    @Nullable
    public TracksHits getCaster() {
        if (this.casterUUID != null && this.m_9236_() instanceof ServerLevel) {
            return (TracksHits)((ServerLevel)this.m_9236_()).m_8791_(this.casterUUID);
        }
        return this.casterID != 0 ? (TracksHits)this.m_9236_().m_6815_(this.casterID) : null;
    }

    public void setCaster(@Nullable Entity caster) {
        this.casterID = caster == null ? 0 : caster.m_19879_();
        this.casterUUID = caster == null ? null : caster.m_20148_();
    }

    public int getTicksTillRemove() {
        return (Integer)this.f_19804_.m_135370_(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBlockPos() {
        return ((Optional)this.f_19804_.m_135370_(BLOCK_POS)).orElse(null);
    }

    private void setBlockPos(@Nullable BlockPos positionIn) {
        this.f_19804_.m_135381_(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.getTicksTillRemove() % 5 == 0) {
            if (!this.isBackwardsFrameCycle) {
                ++this.currentFrame;
                if (this.currentFrame == 4) {
                    this.isBackwardsFrameCycle = true;
                }
            } else {
                --this.currentFrame;
                if (this.currentFrame == 0) {
                    this.isBackwardsFrameCycle = false;
                }
            }
        }
        if (this.getTicksTillRemove() > 0) {
            this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        }
        for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
            if (!livingEntity.m_5801_()) continue;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)SRMobEffects.WEIGHT.get(), 60, 2));
            if (this.getCaster() == null) continue;
            this.getCaster().onTrackedHit(this, (Entity)livingEntity);
        }
        if (this.getTicksTillRemove() == 0) {
            this.m_146870_();
            BlockPos pos = this.getBlockPos();
            if (pos != null && this.fromTrap && this.m_9236_().m_8055_(pos).m_60734_() instanceof RunedGloomyTilesBlock) {
                this.m_9236_().m_46597_(pos, ((Block)SRBlocks.GLOOMY_TILES.get()).m_49966_());
            }
        }
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

