/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.api.control;

public interface IRedstoneControllable {
    public int getPower();

    public int getThreshold();

    public ControlMode getMode();

    public void setPower(int var1);

    public void setControl(int var1, ControlMode var2);

    default public boolean getState() {
        return this.getMode().matches(this.getPower(), this.getThreshold());
    }

    public boolean isControllable();

    public static enum ControlMode {
        DISABLED,
        LOW,
        HIGH,
        EQUAL,
        UNDER,
        UNDER_INC,
        OVER,
        OVER_INC;

        public static final ControlMode[] VALUES;

        boolean matches(int power, int threshold) {
            return switch (this) {
                case LOW -> {
                    if (power <= 0) {
                        yield true;
                    }
                    yield false;
                }
                case HIGH -> {
                    if (power > 0) {
                        yield true;
                    }
                    yield false;
                }
                case EQUAL -> {
                    if (power == threshold) {
                        yield true;
                    }
                    yield false;
                }
                case UNDER -> {
                    if (power < threshold) {
                        yield true;
                    }
                    yield false;
                }
                case OVER -> {
                    if (power > threshold) {
                        yield true;
                    }
                    yield false;
                }
                case UNDER_INC -> {
                    if (power <= threshold) {
                        yield true;
                    }
                    yield false;
                }
                case OVER_INC -> {
                    if (power >= threshold) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }

        static {
            VALUES = ControlMode.values();
        }
    }
}

