/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.item;

import cofh.core.common.capability.templates.AreaEffectMiningItemWrapper;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.init.tags.BlockTagsCoFH;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SickleItem
extends DiggerItem
implements ICoFHItem {
    private static final float DEFAULT_ATTACK_DAMAGE = 2.5f;
    private static final float DEFAULT_ATTACK_SPEED = -2.6f;
    private static final int DEFAULT_BASE_RADIUS = 2;
    private static final int DEFAULT_BASE_HEIGHT = 0;
    protected final int radius;
    protected final int height;
    protected String modId = "";

    public SickleItem(Tier tier, float attackDamageIn, float attackSpeedIn, int radius, int height, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, BlockTagsCoFH.MINEABLE_WITH_SICKLE, builder.m_41503_(tier.m_6609_() * 4));
        this.radius = radius;
        this.height = height;
    }

    public SickleItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, 2, 0, builder);
    }

    public SickleItem(Tier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, -2.6f, 2, 0, builder);
    }

    public SickleItem(Tier tier, Item.Properties builder) {
        this(tier, 2.5f, -2.6f, 2, 0, builder);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50033_) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new AreaEffectMiningItemWrapper(stack, this.radius, this.height, AreaEffectMiningItemWrapper.Type.SICKLE);
    }

    @Override
    public SickleItem setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

