/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.client.event.CoreClientEvents;
import cofh.core.client.gui.FluidFilterScreen;
import cofh.core.client.gui.ItemFilterScreen;
import cofh.core.client.renderer.entity.ElectricFieldRenderer;
import cofh.core.client.renderer.entity.KnifeRenderer;
import cofh.core.client.renderer.entity.model.ArmorFullSuitModel;
import cofh.core.common.capability.CapabilityArchery;
import cofh.core.common.capability.CapabilityAreaEffect;
import cofh.core.common.capability.CapabilityShieldItem;
import cofh.core.common.command.CoFHCommand;
import cofh.core.common.config.ConfigManager;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.common.config.CoreCommandConfig;
import cofh.core.common.config.CoreCommonConfig;
import cofh.core.common.config.CoreEnchantConfig;
import cofh.core.common.enchantment.HoldingEnchantment;
import cofh.core.common.event.ArmorEvents;
import cofh.core.common.network.packet.client.ContainerGuiPacket;
import cofh.core.common.network.packet.client.EffectAddedPacket;
import cofh.core.common.network.packet.client.EffectRemovedPacket;
import cofh.core.common.network.packet.client.ModelUpdatePacket;
import cofh.core.common.network.packet.client.OverlayMessagePacket;
import cofh.core.common.network.packet.client.PlayerMotionPacket;
import cofh.core.common.network.packet.client.TileControlPacket;
import cofh.core.common.network.packet.client.TileGuiPacket;
import cofh.core.common.network.packet.client.TileRedstonePacket;
import cofh.core.common.network.packet.client.TileRenderPacket;
import cofh.core.common.network.packet.client.TileStatePacket;
import cofh.core.common.network.packet.server.ClaimXPPacket;
import cofh.core.common.network.packet.server.ContainerConfigPacket;
import cofh.core.common.network.packet.server.FilterableGuiTogglePacket;
import cofh.core.common.network.packet.server.GhostItemPacket;
import cofh.core.common.network.packet.server.ItemLeftClickPacket;
import cofh.core.common.network.packet.server.ItemModeChangePacket;
import cofh.core.common.network.packet.server.ItemRayTraceBlockPacket;
import cofh.core.common.network.packet.server.ItemRayTraceEntityPacket;
import cofh.core.common.network.packet.server.RedstoneControlPacket;
import cofh.core.common.network.packet.server.SecurityControlPacket;
import cofh.core.common.network.packet.server.SecurityPacket;
import cofh.core.common.network.packet.server.SideConfigPacket;
import cofh.core.common.network.packet.server.StorageClearPacket;
import cofh.core.common.network.packet.server.TileConfigPacket;
import cofh.core.common.network.packet.server.TransferControlPacket;
import cofh.core.compat.curios.CuriosProxy;
import cofh.core.compat.quark.QuarkFlags;
import cofh.core.init.CoreBlockEntities;
import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreContainers;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreEntityDataSerializers;
import cofh.core.init.CoreFluids;
import cofh.core.init.CoreItems;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.init.CoreRecipeSerializers;
import cofh.core.init.CoreSounds;
import cofh.core.util.CoreFlags;
import cofh.core.util.Proxy;
import cofh.core.util.ProxyClient;
import cofh.core.util.crafting.CustomIngredients;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.client.renderer.entity.NothingRenderer;
import cofh.lib.common.loot.TileNBTSync;
import cofh.lib.common.network.PacketHandler;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.Utils;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cofh_core")
public class CoFHCore {
    public static final Logger LOG = LogManager.getLogger((String)"cofh_core");
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("cofh_core", "general"), LOG);
    public static final Proxy PROXY = (Proxy)DistExecutor.unsafeRunForDist(() -> ProxyClient::new, () -> Proxy::new);
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create(ForgeRegistries.BLOCKS, "cofh_core");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create(ForgeRegistries.ITEMS, "cofh_core");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create(ForgeRegistries.FLUIDS, "cofh_core");
    public static final DeferredRegisterCoFH<MenuType<?>> CONTAINERS = DeferredRegisterCoFH.create(ForgeRegistries.MENU_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<Enchantment> ENCHANTMENTS = DeferredRegisterCoFH.create(ForgeRegistries.ENCHANTMENTS, "cofh_core");
    public static final DeferredRegisterCoFH<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = DeferredRegisterCoFH.create(ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, "cofh_core");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.ENTITY_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<MobEffect> MOB_EFFECTS = DeferredRegisterCoFH.create(ForgeRegistries.MOB_EFFECTS, "cofh_core");
    public static final DeferredRegisterCoFH<ParticleType<?>> PARTICLES = DeferredRegisterCoFH.create(ForgeRegistries.PARTICLE_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create(ForgeRegistries.RECIPE_SERIALIZERS, "cofh_core");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = DeferredRegisterCoFH.create(ForgeRegistries.SOUND_EVENTS, "cofh_core");
    public static final DeferredRegisterCoFH<BlockEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.BLOCK_ENTITY_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<FluidType> FLUID_TYPES = DeferredRegisterCoFH.create(ForgeRegistries.Keys.FLUID_TYPES, "cofh_core");
    public static boolean curiosLoaded = false;

    public CoFHCore() {
        ForgeMod.enableMilkFluid();
        curiosLoaded = Utils.isModLoaded("curios");
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registrySetup);
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::capSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::handleIMC);
        modEventBus.addListener(this::registerLootData);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        FLUIDS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITY_DATA_SERIALIZERS.register(modEventBus);
        ENCHANTMENTS.register(modEventBus);
        ENTITIES.register(modEventBus);
        MOB_EFFECTS.register(modEventBus);
        PARTICLES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        FLUID_TYPES.register(modEventBus);
        CONFIG_MANAGER.register(modEventBus).addClientConfig(new CoreClientConfig()).addCommonConfig(new CoreCommonConfig()).addServerConfig(new CoreCommandConfig()).addServerConfig(new CoreEnchantConfig());
        CONFIG_MANAGER.setupClient();
        CONFIG_MANAGER.setupServer();
        CoreItems.register();
        CoreBlocks.register();
        CoreFluids.register();
        CoreContainers.register();
        CoreEnchantments.register();
        CoreEntityDataSerializers.register();
        CoreEntities.register();
        CoreMobEffects.register();
        CoreParticles.register();
        CoreRecipeSerializers.register();
        CoreSounds.register();
        CoreBlockEntities.register();
        CuriosProxy.register();
        ArcheryHelper.addValidBow(Items.f_42411_);
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, TileControlPacket::new);
        PACKET_HANDLER.registerPacket(2, TileGuiPacket::new);
        PACKET_HANDLER.registerPacket(3, TileRedstonePacket::new);
        PACKET_HANDLER.registerPacket(4, TileStatePacket::new);
        PACKET_HANDLER.registerPacket(5, TileRenderPacket::new);
        PACKET_HANDLER.registerPacket(8, ModelUpdatePacket::new);
        PACKET_HANDLER.registerPacket(16, OverlayMessagePacket::new);
        PACKET_HANDLER.registerPacket(17, PlayerMotionPacket::new);
        PACKET_HANDLER.registerPacket(20, FilterableGuiTogglePacket::new);
        PACKET_HANDLER.registerPacket(21, GhostItemPacket::new);
        PACKET_HANDLER.registerPacket(24, ContainerConfigPacket::new);
        PACKET_HANDLER.registerPacket(25, ContainerGuiPacket::new);
        PACKET_HANDLER.registerPacket(28, SecurityPacket::new);
        PACKET_HANDLER.registerPacket(32, TileConfigPacket::new);
        PACKET_HANDLER.registerPacket(33, SecurityControlPacket::new);
        PACKET_HANDLER.registerPacket(34, RedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(35, TransferControlPacket::new);
        PACKET_HANDLER.registerPacket(36, SideConfigPacket::new);
        PACKET_HANDLER.registerPacket(37, StorageClearPacket::new);
        PACKET_HANDLER.registerPacket(38, ClaimXPPacket::new);
        PACKET_HANDLER.registerPacket(64, ItemModeChangePacket::new);
        PACKET_HANDLER.registerPacket(65, ItemLeftClickPacket::new);
        PACKET_HANDLER.registerPacket(66, ItemRayTraceBlockPacket::new);
        PACKET_HANDLER.registerPacket(67, ItemRayTraceEntityPacket::new);
        PACKET_HANDLER.registerPacket(96, EffectAddedPacket::new);
        PACKET_HANDLER.registerPacket(97, EffectRemovedPacket::new);
    }

    private void registrySetup(NewRegistryEvent event) {
        CONFIG_MANAGER.setupCommon();
    }

    private void registerLootData(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS) {
            CoreFlags.manager().setup();
            QuarkFlags.setup();
        }
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ArmorFullSuitModel.ARMOR_FULL_SUIT_LAYER, ArmorFullSuitModel::createBodyLayer);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CoreEntities.THROWN_KNIFE.get(), KnifeRenderer::new);
        event.registerEntityRenderer((EntityType)CoreEntities.ELECTRIC_FIELD.get(), ElectricFieldRenderer::new);
        event.registerEntityRenderer((EntityType)CoreEntities.FROST_FIELD.get(), NothingRenderer::new);
    }

    private void capSetup(RegisterCapabilitiesEvent event) {
        CapabilityArchery.register(event);
        CapabilityAreaEffect.register(event);
        CapabilityShieldItem.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TileNBTSync::setup);
        event.enqueueWork(ArmorEvents::setup);
        event.enqueueWork(CoreFluids::setup);
        event.enqueueWork(CustomIngredients::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)CoreContainers.FLUID_FILTER_CONTAINER.get()), FluidFilterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)CoreContainers.ITEM_FILTER_CONTAINER.get()), ItemFilterScreen::new);
        });
        event.enqueueWork(ProxyClient::registerItemModelProperties);
        event.enqueueWork(() -> CoreClientEvents.addNamespace("cofh_core"));
    }

    private void handleIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(msg -> {
            Object patt12878$temp;
            Object patt12669$temp;
            if (msg.method().equalsIgnoreCase("add_bow_compatibility") && (patt12669$temp = msg.messageSupplier().get()) instanceof Item) {
                Item bow = (Item)patt12669$temp;
                ArcheryHelper.addValidBow(bow);
            } else if (msg.method().equalsIgnoreCase("add_holding_compatibility") && (patt12878$temp = msg.messageSupplier().get()) instanceof Item) {
                Item container = (Item)patt12878$temp;
                HoldingEnchantment.addValidItem(container);
            }
        });
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CoFHCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

