/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FamiliarRingItem
extends Item {
    public FamiliarRingItem(Item.Properties properties) {
        super(properties);
    }

    private static Curio getCurio(ItemStack stack) {
        ICurio icurio = (ICurio)stack.getCapability(CuriosCapability.ITEM).orElse(null);
        if (icurio != null && icurio instanceof Curio) {
            Curio curio = (Curio)icurio;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("familiar")) {
                curio.deserializeNBT(stack.m_41783_().m_128469_("familiar"));
                stack.m_41783_().m_128473_("familiar");
            }
            return curio;
        }
        return null;
    }

    public static IFamiliar getFamiliar(ItemStack stack, Level level) {
        Curio curio = FamiliarRingItem.getCurio(stack);
        return curio == null ? null : curio.getFamiliar(level);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag != null && !tag.m_128441_("familiar")) {
            tag.m_128365_("familiar", (Tag)FamiliarRingItem.getCurio(stack).serializeNBT());
        }
        return tag;
    }

    public int getMaxStackSize(ItemStack stack) {
        ItemNBTUtil.getBoundSpiritName(stack);
        return super.getMaxStackSize(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        FamiliarRingItem.getCurio(stack);
    }

    public boolean m_5812_(ItemStack pStack) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            return DistHelper.isFoil(pStack);
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41784_().m_128471_("occupied")) {
            DistHelper.appendHoverText(stack, worldIn, tooltip, flagIn);
        } else {
            tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".tooltip.empty")));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        IFamiliar familiar;
        if (!playerIn.m_9236_().f_46443_ && target instanceof IFamiliar && ((familiar = (IFamiliar)target).getFamiliarOwner() == playerIn || familiar.getFamiliarOwner() == null) && FamiliarRingItem.getCurio(stack).captureFamiliar(playerIn.m_9236_(), familiar)) {
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CAPTURE);
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("occupied", true);
            ItemNBTUtil.setBoundSpiritName(stack, familiar.getFamiliarEntity().m_5446_().getString());
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43723_().m_21120_(pContext.m_43724_());
        if (!pContext.m_43723_().m_9236_().f_46443_ && FamiliarRingItem.getCurio(stack).releaseFamiliar(pContext.m_43723_(), pContext.m_43725_())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("occupied", false);
            return InteractionResult.m_19078_((boolean)pContext.m_43723_().m_9236_().f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_142312_(CompoundTag pCompoundTag) {
        super.m_142312_(pCompoundTag);
        if (pCompoundTag.m_128441_("forHandleFamiliarTypeTag")) {
            return;
        }
        this.handleFamiliarTypeTag(pCompoundTag);
    }

    public void handleFamiliarTypeTag(CompoundTag tag) {
        ItemStack stack = new ItemStack((ItemLike)this);
        tag.m_128379_("forHandleFamiliarTypeTag", true);
        stack.m_41751_(tag);
        tag.m_128473_("forHandleFamiliarTypeTag");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ICurio icurio = (ICurio)stack.getCapability(CuriosCapability.ITEM).orElse(null);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("familiarType") && icurio instanceof Curio) {
            Curio curio = (Curio)icurio;
            if (server != null) {
                try {
                    ServerLevel level;
                    Entity entity;
                    IFamiliar familiar;
                    EntityType type = EntityType.m_20632_((String)stack.m_41783_().m_128461_("familiarType")).orElse(null);
                    if (type != null && (familiar = (IFamiliar)(entity = type.m_20615_((Level)(level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_))))) != null) {
                        curio.setFamiliar(familiar);
                        stack.m_41783_().m_128379_("occupied", true);
                        stack.m_41783_().m_128365_("familiar", (Tag)curio.serializeNBT());
                    }
                    stack.m_41783_().m_128473_("familiarType");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new Provider(stack);
    }

    private static class Curio
    implements ICurio,
    INBTSerializable<CompoundTag> {
        private final ItemStack stack;
        private IFamiliar familiar;
        private CompoundTag nbt;

        private Curio(ItemStack stack) {
            this.stack = stack;
        }

        private boolean captureFamiliar(Level level, IFamiliar familiar) {
            if (this.getFamiliar(level) != null) {
                return false;
            }
            familiar.getFamiliarEntity().onRemovedFromWorld();
            this.setFamiliar(familiar);
            this.getFamiliar(level).getFamiliarEntity().m_8127_();
            this.getFamiliar(level).getFamiliarEntity().m_20153_();
            this.getFamiliar(level).getFamiliarEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }

        private boolean releaseFamiliar(Player player, Level level) {
            if (this.getFamiliar(level) != null && !this.getFamiliar(level).getFamiliarEntity().isAddedToWorld()) {
                EntityType.m_20645_((CompoundTag)this.getFamiliar(level).getFamiliarEntity().serializeNBT(), (Level)level, e -> {
                    e.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    ((IFamiliar)e).setFamiliarOwner((LivingEntity)player);
                    String name = ItemNBTUtil.getBoundSpiritName(this.stack);
                    e.m_6593_((Component)Component.m_237113_((String)name));
                    level.m_7967_(e);
                    return e;
                });
                this.setFamiliar(null);
                return true;
            }
            return false;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            Level level = slotContext.entity().m_9236_();
            IFamiliar familiar = this.getFamiliar(level);
            if (familiar != null) {
                if (!familiar.getFamiliarEntity().isAddedToWorld()) {
                    familiar.getFamiliarEntity().m_284535_(level);
                }
                if (familiar.getFamiliarOwner() != slotContext.entity()) {
                    return;
                }
                if (!level.f_46443_ && slotContext.entity().f_19797_ % 20 == 0 && familiar.isEffectEnabled(slotContext.entity())) {
                    for (MobEffectInstance effect : familiar.getFamiliarEffects()) {
                        familiar.getFamiliarOwner().m_7292_(effect);
                    }
                }
                familiar.curioTick(slotContext.entity());
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("hasFamiliar", this.familiar != null || this.nbt != null);
            if (this.familiar != null) {
                compound.m_128365_("familiar", (Tag)this.familiar.getFamiliarEntity().serializeNBT());
            } else if (this.nbt != null) {
                compound.m_128365_("familiar", (Tag)this.nbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag compound) {
            if (compound.m_128471_("hasFamiliar")) {
                this.nbt = compound.m_128469_("familiar");
            }
        }

        private IFamiliar getFamiliar(Level level) {
            if (this.familiar != null) {
                return this.familiar;
            }
            if (this.nbt != null) {
                this.familiar = (IFamiliar)EntityType.m_20645_((CompoundTag)this.nbt, (Level)level, Function.identity());
                this.nbt = null;
            }
            return this.familiar;
        }

        private void setFamiliar(IFamiliar familiar) {
            this.familiar = familiar;
            this.nbt = null;
        }
    }

    public static class DistHelper {
        public static void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            IFamiliar familiar;
            if (worldIn != null && (familiar = FamiliarRingItem.getFamiliar(stack, worldIn)) != null) {
                EntityType type = familiar.getFamiliarEntity().m_6095_();
                tooltip.add((Component)Component.m_237110_((String)(stack.m_41778_() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack)), Component.m_237110_((String)(stack.m_41778_() + ".tooltip.familiar_type"), (Object[])new Object[]{TextUtil.formatDemonType(type.m_20676_(), type)}).m_130940_(ChatFormatting.ITALIC)}));
            }
        }

        public static boolean isFoil(ItemStack pStack) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return false;
            }
            IFamiliar familiar = FamiliarRingItem.getFamiliar(pStack, (Level)level);
            if (familiar != null) {
                return familiar.isEffectEnabled((LivingEntity)Minecraft.m_91087_().f_91074_);
            }
            return false;
        }
    }

    private static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final ItemStack stack;
        private Curio curio;
        private final LazyOptional<ICurio> instance = LazyOptional.of(this::get);

        public Provider(ItemStack stack) {
            this.stack = stack;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.instance);
        }

        public CompoundTag serializeNBT() {
            return this.get().serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.get().deserializeNBT(nbt);
        }

        private Curio get() {
            if (this.curio == null) {
                this.curio = new Curio(this.stack);
            }
            return this.curio;
        }
    }
}

