/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit;

import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.api.common.item.IHandleItemMode;
import com.klikli_dev.occultism.client.gui.GuiHelper;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemModes;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class BookOfCallingItem
extends Item
implements IHandleItemMode {
    public static Map<UUID, Long> spiritDeathRegister = new HashMap<UUID, Long>();
    public String translationKeyBase;
    public Predicate<SpiritEntity> targetSpirit;

    public BookOfCallingItem(Item.Properties properties, String translationKeyBase, Predicate<SpiritEntity> targetSpirit) {
        super(properties);
        this.translationKeyBase = translationKeyBase;
        this.targetSpirit = targetSpirit;
    }

    public String getTranslationKeyBase() {
        return this.translationKeyBase;
    }

    public List<ItemMode> getItemModes() {
        return new ArrayList<ItemMode>();
    }

    @Override
    public int getItemMode(ItemStack stack) {
        return ItemNBTUtil.getItemMode(stack);
    }

    @Override
    public void setItemMode(ItemStack stack, int mode) {
        ItemNBTUtil.setItemMode(stack, mode);
    }

    public ItemMode nextItemMode(ItemStack stack) {
        int mode = this.getItemMode(stack);
        mode = (mode + 1) % this.getItemModes().size();
        this.setItemMode(stack, mode);
        return this.getCurrentItemMode(stack);
    }

    public int modeValue(ItemMode mode) {
        return this.getItemModes().indexOf(mode);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (!pPlayer.m_6144_() && pLevel.f_46443_) {
            ItemMode curr = this.getCurrentItemMode(itemStack);
            WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
            GuiHelper.openBookOfCallingGui(curr, workAreaSize);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        Level world = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        CompoundTag entityData = ItemNBTUtil.getSpiritEntityData(itemStack);
        if (entityData != null) {
            if (!world.f_46443_) {
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.m_7949_();
                if (!world.m_8055_(spawnPos).m_60812_((BlockGetter)world, spawnPos).m_83281_()) {
                    spawnPos = spawnPos.m_121945_(facing);
                }
                MutableComponent customName = null;
                if (entityData.m_128441_("CustomName")) {
                    customName = Component.Serializer.m_130701_((String)entityData.m_128461_("CustomName"));
                }
                entityData.m_128473_("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.m_128365_("EntityTag", (Tag)entityData);
                SpiritEntity entity = (SpiritEntity)type.m_20615_(world);
                entity.m_20258_(entityData);
                entity.m_19890_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)entity);
                ItemNBTUtil.updateItemNBTFromEntity(itemStack, entity);
                world.m_7967_((Entity)entity);
                itemStack.m_41783_().m_128473_("spiritData");
                player.f_36095_.m_38946_();
            }
        } else {
            if (player.m_6144_()) {
                return this.handleItemMode(player, world, pos, itemStack, facing);
            }
            if (world.f_46443_) {
                ItemMode curr = this.getCurrentItemMode(itemStack);
                WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
                GuiHelper.openBookOfCallingGui(curr, workAreaSize);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof SpiritEntity)) {
            return InteractionResult.PASS;
        }
        SpiritEntity targetSpirit = (SpiritEntity)target;
        if (target.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!targetSpirit.m_20148_().equals(ItemNBTUtil.getSpiritEntityUUID(stack))) {
            if (player.m_6144_()) {
                if (this.targetSpirit.test(targetSpirit)) {
                    ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.m_20148_());
                    ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.m_7755_().getString());
                    player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_linked"), true);
                    player.m_6674_(hand);
                    player.m_21008_(hand, stack);
                    player.f_36095_.m_38946_();
                    return InteractionResult.SUCCESS;
                }
                if (this.getCurrentItemMode(stack) == ItemModes.SET_DEPOSIT) {
                    if (targetSpirit.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
                        if (boundSpiritId != null) {
                            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(target.m_9236_().m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
                            if (boundSpirit.isPresent()) {
                                boundSpirit.get().setDepositEntityUUID(targetSpirit.m_20148_());
                                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                                ItemNBTUtil.setDepositEntityName(stack, target.m_7755_().getString());
                                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_deposit_entity", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), TextUtil.formatDemonName(targetSpirit.m_7755_().getString())}), true);
                                player.m_6674_(hand);
                                player.m_21008_(hand, stack);
                                player.f_36095_.m_38946_();
                                return InteractionResult.SUCCESS;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
                            return InteractionResult.FAIL;
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                        return InteractionResult.FAIL;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_entity_no_inventory"), true);
                    return InteractionResult.FAIL;
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                return InteractionResult.FAIL;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_uuid_no_match"), true);
            return InteractionResult.FAIL;
        }
        ItemNBTUtil.setSpiritEntityData(stack, targetSpirit.serializeNBT());
        ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.m_20148_());
        ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.m_7755_().getString());
        player.m_6674_(hand);
        player.m_21008_(hand, stack);
        targetSpirit.m_142687_(Entity.RemovalReason.DISCARDED);
        player.f_36095_.m_38946_();
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Long deathTime;
        UUID spiritID;
        if (worldIn.m_46467_() % 1200L == 0L && (spiritID = ItemNBTUtil.getSpiritEntityUUID(stack)) != null && (deathTime = spiritDeathRegister.get(spiritID)) != null && deathTime < worldIn.m_46467_()) {
            spiritDeathRegister.remove(spiritID);
            stack.m_41783_().m_128379_("spiritDead", true);
            stack.m_41783_().m_128473_("spiritUUID");
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)(this.getTranslationKeyBase() + (ItemNBTUtil.getSpiritDead(stack) ? ".tooltip_dead" : ".tooltip")), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public boolean m_5812_(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityData(stack) != null;
    }

    public Rarity m_41460_(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityUUID(stack) != null ? Rarity.RARE : Rarity.COMMON;
    }

    public ItemMode getCurrentItemMode(ItemStack stack) {
        int mode = this.getItemMode(stack);
        if (mode < 0 || mode >= this.getItemModes().size()) {
            mode = 0;
            this.setItemMode(stack, mode);
        }
        return this.getItemModes().get(mode);
    }

    public boolean useWorkAreaSize() {
        return true;
    }

    public InteractionResult handleItemMode(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing) {
        ItemMode itemMode = this.getCurrentItemMode(stack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!world.f_46443_) {
            return itemMode.handle(blockEntity, player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

