/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class MummyFamiliarEntity
extends FamiliarEntity {
    private static final UUID DAMAGE_BONUS = UUID.fromString("6aa62086-7009-402b-9c13-c2de74bf077d");
    private static final int MAX_FIGHT_TIMER = 5;
    private int fightPose;
    private int fightTimer;
    private Vec3 capowPos;
    private Vec3 capowOffset;
    private Vec3 capowOffset0;

    public MummyFamiliarEntity(EntityType<? extends MummyFamiliarEntity> type, Level level) {
        super(type, level);
        this.capowOffset = this.capowOffset0 = Vec3.f_82478_;
        this.capowPos = this.capowOffset0;
        this.fightPose = -1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22277_, 30.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.f_21346_.m_25352_(0, (Goal)new FairyFamiliarEntity.SetAttackTargetGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.fightPose != -1) {
            this.capowOffset0 = this.capowOffset;
            if (this.fightTimer++ == 5) {
                this.fightTimer = 0;
                ++this.fightPose;
                if (this.fightPose == 3) {
                    this.fightPose = -1;
                }
                this.capowPos = new Vec3(this.randNum(2.0), -this.f_19796_.m_188500_(), this.randNum(2.0));
            }
            this.capowOffset = new Vec3(this.randNum(0.1), this.randNum(0.1), this.randNum(0.1));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setCrown(this.m_217043_().m_188500_() < 0.1);
        this.setTooth(this.m_217043_().m_188499_());
        this.setHeka(this.m_217043_().m_188499_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_21011_(InteractionHand pHand, boolean pUpdateSelf) {
        super.m_21011_(pHand, pUpdateSelf);
        this.fightPose = 0;
        this.fightTimer = 0;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance((MobEffect)OccultismEffects.MUMMY_DODGE.get(), 300, 0, false, false));
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    private double randNum(double size) {
        return (this.f_19796_.m_188500_() - 0.5) * size;
    }

    public float getCapowAlpha(float partialTicks) {
        return ((float)(5 - this.fightTimer) - partialTicks) / 5.0f;
    }

    public Vec3 getCapowPosition(float partialTicks) {
        return this.capowPos.m_82549_(this.capowOffset0.m_82549_(this.capowOffset0.m_82546_(this.capowOffset).m_82490_((double)partialTicks)));
    }

    public int getFightPose() {
        return this.fightPose;
    }

    @Override
    public void blacksmithUpgrade() {
        super.blacksmithUpgrade();
        AttributeModifier damage = new AttributeModifier(DAMAGE_BONUS, "Mummy attack bonus", 3.0, AttributeModifier.Operation.ADDITION);
        if (!this.m_21051_(Attributes.f_22281_).m_22109_(damage)) {
            this.m_21051_(Attributes.f_22281_).m_22125_(damage);
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasCrown()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public boolean hasCrown() {
        return this.hasVariant(0);
    }

    private void setCrown(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasHeka() {
        return this.hasVariant(1);
    }

    private void setHeka(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTooth() {
        return this.hasVariant(2);
    }

    private void setTooth(boolean b) {
        this.setVariant(2, b);
    }
}

