/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.capability;

import com.klikli_dev.occultism.registry.OccultismCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DoubleJumpCapability
implements INBTSerializable<CompoundTag> {
    private int jumps = 0;

    public int getJumps() {
        return this.jumps;
    }

    public void setJumps(int i) {
        this.jumps = i;
    }

    public void addJump() {
        ++this.jumps;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("jumps", this.jumps);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.jumps = nbt.m_128451_("jumps");
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<DoubleJumpCapability> doubleJumpCapability = LazyOptional.of(DoubleJumpCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == OccultismCapabilities.DOUBLE_JUMP) {
                return this.doubleJumpCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.doubleJumpCapability.map(DoubleJumpCapability::serializeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.doubleJumpCapability.ifPresent(capability -> capability.deserializeNBT(nbt));
        }
    }
}

