/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.util.Version;

public final class LeafMetaData {
    private final int createdVersionMajor;
    private final Version minVersion;
    private final Sort sort;
    private final boolean hasBlocks;

    public LeafMetaData(int createdVersionMajor, Version minVersion, Sort sort, boolean hasBlocks) {
        this.createdVersionMajor = createdVersionMajor;
        if (createdVersionMajor > Version.LATEST.major) {
            throw new IllegalArgumentException("createdVersionMajor is in the future: " + createdVersionMajor);
        }
        if (createdVersionMajor < 6) {
            throw new IllegalArgumentException("createdVersionMajor must be >= 6, got: " + createdVersionMajor);
        }
        if (createdVersionMajor >= 7 && minVersion == null) {
            throw new IllegalArgumentException("minVersion must be set when createdVersionMajor is >= 7");
        }
        this.minVersion = minVersion;
        this.sort = sort;
        this.hasBlocks = hasBlocks;
    }

    public int getCreatedVersionMajor() {
        return this.createdVersionMajor;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean hasBlocks() {
        return this.hasBlocks;
    }
}

