/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.enigmaticlegacy.triggers.RevelationGainTrigger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RevelationTome
extends ItemBase
implements Vanishable {
    public static final String revelationPointsTag = "revelationPoints";
    public static final String xpPointsTag = "xpPoints";
    public static final String formerReadersTag = "formerReaders";
    public static final String lastHolderTag = "lastHolder";
    public final TomeType theType;
    public final String persistantPointsTag;

    public RevelationTome(Rarity rarity, TomeType type) {
        super(ItemBase.getDefaultProperties().m_41497_(rarity).m_41487_(1));
        this.theType = type;
        this.persistantPointsTag = "enigmaticlegacy.revelation_points_" + this.theType.typeName;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof ServerPlayer) {
            ItemNBTHelper.setUUID(stack, lastHolderTag, entityIn.m_20148_());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!RevelationTome.havePlayerRead(player, stack)) {
            RevelationTome.markRead(player, stack);
            int xp = ItemNBTHelper.getInt(stack, xpPointsTag, random.nextInt(1000));
            int revelation = ItemNBTHelper.getInt(stack, revelationPointsTag, 1);
            if (player instanceof ServerPlayer) {
                int currentPoints = SuperpositionHandler.getPersistentInteger(player, this.persistantPointsTag, 0);
                ExperienceHelper.addPlayerXP(player, xp);
                SuperpositionHandler.setPersistentInteger(player, this.persistantPointsTag, currentPoints + revelation);
                world.m_5594_(null, BlockPos.m_274446_((Position)player.m_20182_()), EnigmaticSounds.LEARN, SoundSource.PLAYERS, 0.75f, 1.0f);
                RevelationGainTrigger.INSTANCE.trigger((ServerPlayer)player, this.theType, currentPoints + revelation);
                RevelationGainTrigger.INSTANCE.trigger((ServerPlayer)player, TomeType.GENERIC, RevelationTome.getGenericPoints(player));
            } else {
                EnigmaticLegacy.PROXY.pushRevelationToast(stack, xp, revelation);
            }
            player.m_6674_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome4");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (!RevelationTome.havePlayerRead((Player)Minecraft.m_91087_().f_91074_, stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTomeClick");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTomeMarkRead");
        }
    }

    public static int getGenericPoints(Player player) {
        int overworldPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.OVERWORLD.typeName, 0);
        int netherPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.NETHER.typeName, 0);
        int endPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.END.typeName, 0);
        return overworldPoints + netherPoints + endPoints;
    }

    public ItemStack createTome(int revelationPoints, int experiencePoints) {
        ItemStack theTome = new ItemStack((ItemLike)this);
        ItemNBTHelper.setInt(theTome, revelationPointsTag, revelationPoints);
        ItemNBTHelper.setInt(theTome, xpPointsTag, experiencePoints);
        return theTome;
    }

    public static boolean havePlayerRead(Player player, ItemStack tome) {
        ListTag uncheckedList;
        boolean haveReadBefore = false;
        CompoundTag nbt = ItemNBTHelper.getNBT(tome);
        Object object = uncheckedList = nbt.m_128441_(formerReadersTag) ? nbt.m_128423_(formerReadersTag) : new ListTag();
        if (uncheckedList instanceof ListTag) {
            ListTag list = uncheckedList;
            for (Tag entry : list) {
                if (!entry.m_7916_().equals(player.m_36316_().getName())) continue;
                haveReadBefore = true;
                break;
            }
        }
        return haveReadBefore;
    }

    public static void markRead(Player player, ItemStack tome) {
        CompoundTag nbt = ItemNBTHelper.getNBT(tome);
        ListTag list = nbt.m_128423_(formerReadersTag) instanceof ListTag ? (ListTag)nbt.m_128423_(formerReadersTag) : new ListTag();
        list.add((Object)StringTag.m_129297_((String)player.m_36316_().getName()));
        nbt.m_128365_(formerReadersTag, (Tag)list);
        tome.m_41751_(nbt);
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return 400;
    }

    public static enum TomeType {
        OVERWORLD("overworld"),
        NETHER("nether"),
        END("end"),
        GENERIC("generic");

        public final String typeName;

        private TomeType(String name) {
            this.typeName = name;
        }

        public static TomeType resolveType(@Nonnull String type) {
            if (type.equals("overworld")) {
                return OVERWORLD;
            }
            if (type.equals("nether")) {
                return NETHER;
            }
            if (type.equals("end")) {
                return END;
            }
            return GENERIC;
        }
    }
}

