/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.objects.TransientPlayerData;
import com.aizistral.enigmaticlegacy.triggers.ForbiddenFruitTrigger;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForbiddenFruit
extends ItemBase
implements Vanishable {
    public static final String consumedFruitTag = "ConsumedForbiddenFruit";
    public static Omniconfig.PerhapsParameter regenerationSubtraction;
    public static Omniconfig.DoubleParameter debuffDurationMultiplier;
    public static Omniconfig.BooleanParameter renderHungerBar;
    public static Omniconfig.BooleanParameter replaceHungerBar;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ForbiddenFruit");
        if (builder.config.getSidedType() != Configuration.SidedConfigType.CLIENT) {
            regenerationSubtraction = builder.comment("How much should be subtracted from regeneration of player who have consumed The Forbidden Fruit. ").max(100.0).getPerhaps("RegenerationSubtraction", 80);
            debuffDurationMultiplier = builder.comment("Multiplier for duration of debuffs applied upon consumption of The Forbidden Fruit. Setting it to 0 will disable debuffs entirely.").getDouble("DebuffDurationMultiplier", 1.0);
        } else {
            renderHungerBar = builder.comment("Whether or not hunger bar should be rendered at all after Forbidden Fruit was consumed.").getBoolean("RenderHungerbar", true);
            replaceHungerBar = builder.comment("Whether or not food icons on hunger bar should be replaced when custom ones after Forbidden Fruit was consumed.").getBoolean("ReplaceHungerBar", true);
        }
        builder.popPrefix();
    }

    public ForbiddenFruit() {
        super(ForbiddenFruit.getDefaultProperties().m_41497_(Rarity.RARE).m_41486_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenFruit1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenFruit2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenFruit3", ChatFormatting.GOLD, regenerationSubtraction + "%");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenFruitLore");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public boolean haveConsumedFruit(Player player) {
        return TransientPlayerData.get(player).getConsumedForbiddenFruit();
    }

    public void defineConsumedFruit(Player player, boolean consumedOrNot) {
        TransientPlayerData.get(player).setConsumedForbiddenFruit(consumedOrNot);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (entityLiving.m_217043_().m_188501_() - entityLiving.m_217043_().m_188501_()) * 0.4f);
        if (!(entityLiving instanceof Player) || !((Player)entityLiving).m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        entityLiving.m_146850_(GameEvent.f_157806_);
        if (entityLiving instanceof Player) {
            this.onConsumed(worldIn, (Player)entityLiving, stack);
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public void onConsumed(Level worldIn, Player player, ItemStack food) {
        this.defineConsumedFruit(player, true);
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            ForbiddenFruitTrigger.INSTANCE.trigger(playerMP);
            double multiplier = debuffDurationMultiplier.getValue();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, (int)(300.0 * multiplier), 3, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, (int)(300.0 * multiplier), 2, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(400.0 * multiplier), 3, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(500.0 * multiplier), 2, false, true));
        }
    }

    public boolean canEat(Level world, Player player, ItemStack food) {
        return !this.haveConsumedFruit(player);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.canEat(worldIn, playerIn, playerIn.m_21120_(handIn))) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)playerIn.m_21120_(handIn));
        }
        return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.EAT;
    }
}

