/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.items.IBindable;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.objects.TransientPlayerData;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.enigmaticlegacy.packets.server.PacketUpdateElytraBoosting;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class EnigmaticElytra
extends ItemBaseCurio
implements IBindable {
    private static final AttributeModifier ELYTRA_MODIFIER = new AttributeModifier(UUID.fromString("44dfce5a-2f09-4f19-bc29-9b0324cd2a40"), "enigmaticlegacy:elytra_modifier", 1.0, AttributeModifier.Operation.ADDITION);
    @OnlyIn(value=Dist.CLIENT)
    private static boolean isBoosting;

    public EnigmaticElytra() {
        super(ItemBaseCurio.getDefaultProperties().m_41503_(5000).m_41486_().m_41497_(Rarity.EPIC));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticElytra1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticElytra2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticElytra3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        int ticks;
        LivingEntity livingEntity2 = context.entity();
        if (livingEntity2 instanceof Player) {
            Player player = (Player)livingEntity2;
            if (player.m_9236_().f_46443_) {
                this.handleBoosting(player);
            }
        }
        if ((ticks = (livingEntity = context.entity()).m_21256_()) > 0 && livingEntity.m_21255_()) {
            stack.elytraFlightTick(livingEntity, ticks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleBoosting(Player player) {
        if (Minecraft.m_91087_().f_91074_ != player) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() && this.boostPlayer(player)) {
            if (!isBoosting) {
                isBoosting = true;
                EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketUpdateElytraBoosting(true));
            }
        } else if (isBoosting) {
            isBoosting = false;
            EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketUpdateElytraBoosting(false));
        }
    }

    private boolean boostPlayer(Player player) {
        if (player.m_21255_()) {
            Vec3 vec31 = player.m_20154_();
            Vec3 vec32 = player.m_20184_();
            player.m_20256_(vec32.m_82520_(vec31.f_82479_ * 0.1 + (vec31.f_82479_ * 1.5 - vec32.f_82479_) * 0.5, vec31.f_82480_ * 0.1 + (vec31.f_82480_ * 1.5 - vec32.f_82480_) * 0.5, vec31.f_82481_ * 0.1 + (vec31.f_82481_ * 1.5 - vec32.f_82481_) * 0.5));
            return true;
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        return attributes;
    }

    public boolean m_6832_(ItemStack repairedItem, ItemStack material) {
        return material.m_150930_((Item)EnigmaticItems.ETHERIUM_INGOT);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
        ItemStack itemstack1 = player.m_6844_(equipmentslot);
        if (itemstack1.m_41619_()) {
            player.m_8061_(equipmentslot, itemstack.m_41777_());
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return entity instanceof Player && ElytraItem.m_41140_((ItemStack)stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.m_9236_().f_46443_) {
                int nextFlightTick = flightTicks + 1;
                if (nextFlightTick % 10 == 0) {
                    if (nextFlightTick % 20 == 0) {
                        stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
                    }
                    entity.m_146850_(GameEvent.f_223705_);
                }
            } else {
                this.handleBoosting(player);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerPlayer player;
            Player player2;
            ItemStack stack = null;
            AttributeInstance attribute = event.player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
            attribute.m_22130_(ELYTRA_MODIFIER);
            if (!attribute.m_22109_(ELYTRA_MODIFIER) && (stack = SuperpositionHandler.getEnigmaticElytra((LivingEntity)event.player)) != null && stack.m_150930_((Item)this) && ElytraItem.m_41140_((ItemStack)stack)) {
                attribute.m_22118_(ELYTRA_MODIFIER);
            }
            if ((player2 = event.player) instanceof ServerPlayer && TransientPlayerData.get((Player)(player = (ServerPlayer)player2)).isElytraBoosting()) {
                int flightTicks;
                int nextFlightTick;
                this.boostPlayer((Player)player);
                if (stack != null && stack.m_150930_((Item)this) && (nextFlightTick = (flightTicks = player.m_21256_()) + 1) % 5 == 0) {
                    stack.m_41622_(1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.CHEST));
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTickClient(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && event.player.m_9236_().m_5776_() && TransientPlayerData.get(player = event.player).isElytraBoosting()) {
            if (!player.m_21255_()) {
                if (event.player == Minecraft.m_91087_().f_91074_) {
                    this.handleBoosting(player);
                    return;
                }
                TransientPlayerData.get(player).setElytraBoosting(false);
                return;
            }
            int amount = 3;
            double rangeModifier = 0.1;
            for (int counter = 0; counter <= amount; ++counter) {
                Vector3 vec = Vector3.fromEntityCenter((Entity)player);
                vec = vec.add(Math.random() - 0.5, -1.0 + Math.random() - 0.5, Math.random() - 0.5);
                player.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123799_, true, vec.x, vec.y, vec.z, (Math.random() - 0.5) * 2.0 * rangeModifier, (Math.random() - 0.5) * 2.0 * rangeModifier, (Math.random() - 0.5) * 2.0 * rangeModifier);
            }
        }
    }
}

