/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.helpers;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTableHelper {
    public static Field isFrozenTable = null;
    public static Field isFrozenPool = null;
    public static Field lootPoolsTable = null;

    public static void unfreezePlease(LootTable table) {
        try {
            isFrozenTable.set(table, false);
            List poolList = (List)lootPoolsTable.get(table);
            for (LootPool pool : poolList) {
                LootTableHelper.unfreezePlease(pool);
            }
        }
        catch (Throwable ex) {
            EnigmaticLegacy.LOGGER.fatal("FAILED TO UNFREEZE LOOT TABLE");
            throw new RuntimeException(ex);
        }
    }

    public static void unfreezePlease(LootPool pool) {
        try {
            isFrozenPool.set(pool, false);
        }
        catch (Throwable ex) {
            EnigmaticLegacy.LOGGER.fatal("FAILED TO UNFREEZE LOOT POOL");
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            isFrozenTable = LootTable.class.getDeclaredField("isFrozen");
            isFrozenPool = LootPool.class.getDeclaredField("isFrozen");
            try {
                lootPoolsTable = LootTable.class.getDeclaredField("pools");
            }
            catch (NoSuchFieldException ex) {
                lootPoolsTable = LootTable.class.getDeclaredField("f_79109_");
            }
            isFrozenTable.setAccessible(true);
            isFrozenPool.setAccessible(true);
            lootPoolsTable.setAccessible(true);
        }
        catch (Throwable ex) {
            EnigmaticLegacy.LOGGER.fatal("FAILED TO REFLECT LOOTTABLE FIELDS");
            EnigmaticLegacy.LOGGER.catching(ex);
            throw new RuntimeException(ex);
        }
    }
}

