/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.crafting;

import com.aizistral.enigmaticlegacy.items.EnchantmentTransposer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantmentTransposingRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<EnchantmentTransposingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(EnchantmentTransposingRecipe::new);

    public EnchantmentTransposingRecipe(ResourceLocation id, CraftingBookCategory ctg) {
        super(id, ctg);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack transposer = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() instanceof EnchantmentTransposer) {
                if (transposer == null) {
                    transposer = checkedItemStack.m_41777_();
                    continue;
                }
                return ItemStack.f_41583_;
            }
            stackList.add(checkedItemStack);
        }
        if (transposer != null && stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41793_() && this.canDisenchant(transposer, (ItemStack)stackList.get(0))) {
            return (ItemStack)this.disenchant(transposer, (ItemStack)stackList.get(0)).m_14418_();
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack transposer = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() instanceof EnchantmentTransposer) {
                if (transposer == null) {
                    transposer = checkedItemStack.m_41777_();
                    continue;
                }
                return false;
            }
            stackList.add(checkedItemStack);
        }
        return transposer != null && stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41793_() && this.canDisenchant(transposer, (ItemStack)stackList.get(0));
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        ItemStack returned;
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        HashMap<ItemStack, Integer> stackList = new HashMap<ItemStack, Integer>();
        ItemStack transposer = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() instanceof EnchantmentTransposer) {
                if (transposer == null) {
                    transposer = checkedItemStack.m_41777_();
                    continue;
                }
                return remaining;
            }
            stackList.put(checkedItemStack, i);
        }
        if (transposer != null && stackList.size() == 1 && (returned = (ItemStack)stackList.keySet().iterator().next()).m_41793_() && this.canDisenchant(transposer, returned)) {
            remaining.set(((Integer)stackList.get(returned)).intValue(), (Object)((ItemStack)this.disenchant(transposer, returned).m_14419_()));
        }
        return remaining;
    }

    private Tuple<ItemStack, ItemStack> disenchant(ItemStack transposer, ItemStack target) {
        Map transposed = EnchantmentHelper.m_44831_((ItemStack)target);
        Map leftover = EnchantmentHelper.m_44831_((ItemStack)target);
        transposed.keySet().removeIf(enchant -> !((EnchantmentTransposer)transposer.m_41720_()).canTranspose((Enchantment)enchant));
        leftover.keySet().removeIf(enchant -> ((EnchantmentTransposer)transposer.m_41720_()).canTranspose((Enchantment)enchant));
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)transposed, (ItemStack)book);
        ItemStack item = target.m_41777_();
        EnchantmentHelper.m_44865_((Map)leftover, (ItemStack)item);
        return new Tuple((Object)book, (Object)item);
    }

    private boolean canDisenchant(ItemStack transposer, ItemStack target) {
        return EnchantmentHelper.m_44831_((ItemStack)target).keySet().stream().anyMatch(((EnchantmentTransposer)transposer.m_41720_())::canTranspose);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

