/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.recipes.builder;

import com.google.gson.JsonObject;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.recipe.ClibanoRecipe;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public record ClibanoRecipeBuilder(RecipeCategory category, Item result, Ingredient ingredient, float experience, int cookingTime, Advancement.Builder advancement, ClibanoRecipe.ResidueInfo residueInfo, ClibanoFireType requiredFireType) implements RecipeBuilder
{
    public static ClibanoRecipeBuilder of(RecipeCategory category, ItemLike result, Ingredient ingredient, float experience, int cookingTime) {
        return ClibanoRecipeBuilder.of(category, result, ingredient, experience, cookingTime, ClibanoRecipe.ResidueInfo.NONE);
    }

    public static ClibanoRecipeBuilder of(RecipeCategory category, ItemLike result, Ingredient ingredient, float experience, int cookingTime, ClibanoRecipe.ResidueInfo residueInfo) {
        return new ClibanoRecipeBuilder(category, result.m_5456_(), ingredient, experience, cookingTime, Advancement.Builder.m_138353_(), residueInfo, ClibanoFireType.FIRE);
    }

    public static ClibanoRecipeBuilder of(RecipeCategory category, ItemLike result, Ingredient ingredient, float experience, int cookingTime, ClibanoRecipe.ResidueInfo residueInfo, ClibanoFireType requiredFireType) {
        return new ClibanoRecipeBuilder(category, result.m_5456_(), ingredient, experience, cookingTime, Advancement.Builder.m_138353_(), residueInfo, requiredFireType);
    }

    @Nonnull
    public RecipeBuilder m_126132_(@Nonnull String criterionName, @Nonnull CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    @Nonnull
    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(@Nonnull Consumer<FinishedRecipe> finishedRecipeConsumer) {
        ResourceLocation recipeId = RecipeBuilder.m_176493_((ItemLike)this.m_142372_());
        this.m_126140_(finishedRecipeConsumer, new ResourceLocation("forbidden_arcanus", "clibano_combustion/" + recipeId.m_135815_() + "_from_clibano_combusting"));
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> finishedRecipeConsumer, @Nonnull ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        ResourceLocation advancementId = new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.category.m_247710_() + "/" + recipeId.m_135815_());
        finishedRecipeConsumer.accept(new Result(recipeId, this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, advancementId, this.residueInfo, this.requiredFireType));
    }

    private void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final ClibanoRecipe.ResidueInfo residueInfo;
        private final ClibanoFireType fireType;

        public Result(ResourceLocation recipeId, Ingredient ingredient, Item result, float experience, int cookingTime, Advancement.Builder advancement, ResourceLocation advancementId, ClibanoRecipe.ResidueInfo residueInfo, ClibanoFireType fireType) {
            this.recipeId = recipeId;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.residueInfo = residueInfo;
            this.fireType = fireType;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cooking_time", (Number)this.cookingTime);
            if (this.fireType != ClibanoFireType.FIRE) {
                json.addProperty("fire_type", this.fireType.m_7912_());
            }
            this.residueInfo.toJson(json);
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.CLIBANO_SERIALIZER.get();
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

