/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceModifier;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesStorage;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerAccessor;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.CreateValidRitualIndicatorPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.RemoveValidRitualIndicatorPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateForgeRitualPacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdatePedestalPacket;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.valhelsia.valhelsia_core.api.common.util.SerializableComponent;
import org.jetbrains.annotations.Nullable;

public class RitualManager
implements SerializableComponent {
    public static final float DEFAULT_RITUAL_TIME = 500.0f;
    public static final Vec3i[] PEDESTAL_OFFSETS = new Vec3i[]{new Vec3i(-3, 0, 0), new Vec3i(-2, 0, -2), new Vec3i(0, 0, -3), new Vec3i(2, 0, -2), new Vec3i(3, 0, 0), new Vec3i(2, 0, 2), new Vec3i(0, 0, 3), new Vec3i(-2, 0, 2)};
    private final MainIngredientAccessor mainIngredientAccessor;
    private final EnhancerAccessor enhancerAccessor;
    private ServerLevel level;
    private BlockPos pos;
    private int forgeTier;
    private boolean loaded = false;
    private final HashMap<PedestalBlockEntity, ItemStack> cachedIngredients = new HashMap();
    @Nullable
    private Ritual validRitual;
    @Nullable
    private Ritual activeRitual;
    private int counter;
    private int lightningCounter;

    public RitualManager(MainIngredientAccessor accessor, EnhancerAccessor enhancerAccessor, int forgeTier) {
        this.mainIngredientAccessor = accessor;
        this.enhancerAccessor = enhancerAccessor;
        this.forgeTier = forgeTier;
    }

    public void setup(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public void setForgeTier(int forgeTier) {
        this.forgeTier = forgeTier;
    }

    private boolean canStart() {
        return this.validRitual != null;
    }

    @Nullable
    public Ritual getActiveRitual() {
        return this.activeRitual;
    }

    public void setActiveRitual(@Nullable Ritual ritual) {
        this.activeRitual = ritual;
        ResourceLocation resourceLocation = null;
        if (ritual != null) {
            resourceLocation = this.level.m_9598_().m_175515_(FARegistries.RITUAL).m_7981_((Object)ritual);
        }
        NetworkHandler.sendToTrackingChunk(this.level.m_46745_(this.pos), new UpdateForgeRitualPacket(this.pos, resourceLocation));
    }

    public boolean isRitualActive() {
        return this.activeRitual != null;
    }

    public void tryStartRitual(EssencesStorage storage, BooleanConsumer started) {
        if (this.canStart()) {
            this.startRitual(storage, this.validRitual);
            started.accept(true);
            return;
        }
        started.accept(false);
    }

    public void updateIngredient(PedestalBlockEntity pedestal, ItemStack stack, EssencesDefinition definition) {
        if (stack.m_41619_()) {
            this.cachedIngredients.remove((Object)pedestal);
        } else {
            this.cachedIngredients.put(pedestal, stack);
        }
        this.updateValidRitual(definition);
    }

    public void updateValidRitual(EssencesDefinition definition) {
        boolean oldValue = this.validRitual != null;
        for (Ritual ritual : this.level.m_9598_().m_175515_(FARegistries.RITUAL)) {
            if (!this.canStartRitual(ritual, definition)) continue;
            if (!oldValue) {
                NetworkHandler.sendToTrackingChunk(this.level.m_46745_(this.pos), new CreateValidRitualIndicatorPacket(this.pos));
            }
            this.validRitual = ritual;
            return;
        }
        this.validRitual = null;
        if (oldValue && !this.isRitualActive()) {
            NetworkHandler.sendToTrackingChunk(this.level.m_46745_(this.pos), new RemoveValidRitualIndicatorPacket(this.pos));
        }
    }

    public boolean canStartRitual(Ritual ritual, EssencesDefinition definition) {
        List<EssenceModifier> modifiers = this.enhancerAccessor.getEnhancers().stream().map(EnhancerDefinition::effects).flatMap(Collection::stream).filter(effect -> effect instanceof EssenceModifier).map(effect -> (EssenceModifier)((Object)effect)).toList();
        EssencesDefinition updatedEssences = ritual.essences().applyModifiers(modifiers);
        Ritual.RitualStartContext context = Ritual.RitualStartContext.of((Level)this.level, this.pos, this.forgeTier, this.cachedIngredients.values(), this.mainIngredientAccessor.get(), this.enhancerAccessor.getEnhancers());
        return definition.hasMoreThan(updatedEssences) && ritual.canStart(context);
    }

    public void startRitual(EssencesStorage storage, Ritual ritual) {
        this.setActiveRitual(ritual);
        ritual.createMagicCircle((Level)this.level, this.pos, 0);
        storage.reduce(ritual.essences());
    }

    public void tick(EssencesDefinition definition) {
        if (!this.loaded && this.level != null) {
            for (Vec3i vec3i : PEDESTAL_OFFSETS) {
                PedestalBlockEntity blockEntity;
                BlockPos offsetPos = this.pos.m_121955_(vec3i);
                BlockEntity blockEntity2 = this.level.m_7702_(offsetPos);
                if (!(blockEntity2 instanceof PedestalBlockEntity) || (blockEntity = (PedestalBlockEntity)blockEntity2).getStack().m_41619_()) continue;
                this.updateIngredient(blockEntity, blockEntity.getStack(), definition);
            }
            this.loaded = true;
        }
        if (!this.isRitualActive()) {
            return;
        }
        RandomSource random = this.level.m_213780_();
        float progress = RitualManager.getRitualProgress(this.counter);
        ++this.counter;
        if (this.lightningCounter != 0) {
            ++this.lightningCounter;
            if (this.lightningCounter == 300) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                this.forEachPedestal(PedestalBlockEntity::hasStack, pedestalBlockEntity -> list.add(pedestalBlockEntity.getStack()));
                if (!this.getActiveRitual().checkIngredients(list, this.mainIngredientAccessor.get())) {
                    this.failRitual();
                    return;
                }
                this.lightningCounter = 0;
            }
        }
        this.forEachPedestal(PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
            BlockPos pedestalPos = pedestalBlockEntity.m_58899_();
            if (pedestalBlockEntity.getItemHeight() != 140) {
                int height = pedestalBlockEntity.getItemHeight() + 1;
                pedestalBlockEntity.setItemHeight(height);
                NetworkHandler.sendToTrackingChunk(this.level.m_46745_(pedestalPos), new UpdatePedestalPacket(pedestalPos, pedestalBlockEntity.getStack(), height));
            }
            this.addItemParticles(pedestalPos, pedestalBlockEntity.getItemHeight(), pedestalBlockEntity.getStack());
        });
        if (progress == 0.5f && random.m_188500_() <= this.getFailureChance() * 2.0) {
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBolt>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), (Level)this.level);
            entity.m_6034_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.0, (double)this.pos.m_123343_() + 0.5);
            entity.m_20874_(true);
            this.level.m_7967_((Entity)entity);
            ++this.lightningCounter;
            this.forEachPedestal(PedestalBlockEntity::hasStack, pedestalBlockEntity -> {
                if (random.m_188499_()) {
                    ItemStack stack = pedestalBlockEntity.getStack().m_41777_();
                    BlockPos pedestalPos = pedestalBlockEntity.m_58899_();
                    this.level.m_7967_((Entity)new ItemEntity((Level)this.level, (double)pedestalPos.m_123341_() + 0.5, (double)((float)pedestalPos.m_123342_() + (float)pedestalBlockEntity.getItemHeight() / 100.0f), (double)pedestalPos.m_123343_() + 0.5, stack));
                    pedestalBlockEntity.clearStack((Level)this.level);
                }
            });
        }
        if (progress == 1.0f) {
            if (random.m_188500_() > this.getFailureChance()) {
                this.finishRitual();
            } else {
                this.failRitual();
            }
        }
    }

    public void finishRitual() {
        this.activeRitual.removeMagicCircle((Level)this.level, this.pos);
        this.activeRitual.result().apply(this.mainIngredientAccessor, (Level)this.level, this.pos);
        this.reset();
        this.clearPedestals();
    }

    public void failRitual() {
        ItemStack stack = this.mainIngredientAccessor.get();
        this.activeRitual.removeMagicCircle((Level)this.level, this.pos);
        this.reset();
        if (!stack.m_41619_()) {
            this.level.m_7967_((Entity)new ItemEntity((Level)this.level, (double)this.pos.m_123341_() + 0.5, (double)(this.pos.m_123342_() + 1), (double)this.pos.m_123343_() + 0.5, stack));
            this.mainIngredientAccessor.set(ItemStack.f_41583_);
        }
        this.clearPedestals();
        this.level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.HUGE_MAGIC_EXPLOSION.get()), (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5, 0, 1.0, 0.0, 0.0, 0.0);
        this.level.m_6263_(null, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.m_213780_().m_188501_() - this.level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
    }

    private void clearPedestals() {
        this.cachedIngredients.keySet().forEach(blockEntity -> blockEntity.clearStack((Level)this.level, false));
        this.cachedIngredients.clear();
        this.validRitual = null;
    }

    private void addItemParticles(BlockPos pedestalPos, int itemHeight, ItemStack stack) {
        double posX = (double)pedestalPos.m_123341_() + 0.5;
        double posY = (double)pedestalPos.m_123342_() + 0.1 + (double)((float)itemHeight / 100.0f);
        double posZ = (double)pedestalPos.m_123343_() + 0.5;
        double xSpeed = 0.1 * (double)(this.pos.m_123341_() - pedestalPos.m_123341_());
        double ySpeed = 0.22;
        double zSpeed = 0.1 * (double)(this.pos.m_123343_() - pedestalPos.m_123343_());
        if (this.level.m_213780_().m_188500_() < 0.6) {
            this.level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), posX, posY, posZ, 0, xSpeed, ySpeed, zSpeed, 0.9);
        }
    }

    private void reset() {
        this.counter = 0;
        this.lightningCounter = 0;
        this.validRitual = null;
        this.setActiveRitual(null);
    }

    public double getFailureChance() {
        return 0.0;
    }

    public static float getRitualProgress(float counter) {
        return counter / 500.0f;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.isRitualActive()) {
            tag.m_128359_("ActiveRitual", ((ResourceKey)this.level.m_9598_().m_175515_(FARegistries.RITUAL).m_7854_((Object)this.activeRitual).orElseThrow()).toString());
            tag.m_128405_("Counter", this.counter);
            if (this.lightningCounter != 0) {
                tag.m_128405_("LightningCounter", this.lightningCounter);
            }
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ActiveRitual")) {
            this.setActiveRitual((Ritual)this.level.m_9598_().m_175515_(FARegistries.RITUAL).m_7745_(new ResourceLocation(tag.m_128461_("ActiveRitual"))));
            this.counter = tag.m_128451_("Counter");
            if (tag.m_128441_("LightningCounter")) {
                this.lightningCounter = tag.m_128451_("LightningCounter");
            }
        }
    }

    public void forEachPedestal(Predicate<PedestalBlockEntity> predicate, Consumer<PedestalBlockEntity> consumer) {
        for (PedestalBlockEntity blockEntity : this.cachedIngredients.keySet()) {
            if (!predicate.test(blockEntity)) continue;
            consumer.accept(blockEntity);
        }
    }

    public static interface MainIngredientAccessor {
        public ItemStack get();

        public void set(ItemStack var1);
    }
}

