/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.essence;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceModifier;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;

public class EssencesStorage
extends EnumMap<EssenceType, Integer> {
    public EssencesStorage() {
        super(EssenceType.class);
    }

    public EssencesStorage(int aureal, int souls, int blood, int experience) {
        super(EssenceType.class);
        this.put(EssenceType.AUREAL, aureal);
        this.put(EssenceType.SOULS, souls);
        this.put(EssenceType.BLOOD, blood);
        this.put(EssenceType.EXPERIENCE, experience);
    }

    public void reduce(EssencesDefinition definition) {
        definition.forEach((EssenceType type, Integer integer) -> this.put((EssenceType)((Object)type), this.getOrDefault(type, 0) - integer));
    }

    @Override
    public Integer put(EssenceType key, Integer value) {
        return super.put(key, Math.max(value, 0));
    }

    public void modify(EssenceType type, UnaryOperator<Integer> modifier) {
        this.put(type, (Integer)modifier.apply((Integer)this.get((Object)type)));
    }

    public void applyModifiers(List<EssenceModifier> modifiers) {
        for (EssenceModifier modifier : modifiers) {
            this.modify(modifier.getEssenceType(), modifier::getModifiedValue);
        }
    }

    public EssencesDefinition immutable() {
        return new EssencesDefinition(this.getOrDefault((Object)EssenceType.AUREAL, 0), this.getOrDefault((Object)EssenceType.SOULS, 0), this.getOrDefault((Object)EssenceType.BLOOD, 0), this.getOrDefault((Object)EssenceType.EXPERIENCE, 0));
    }
}

