/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderFilterSlotPositioning;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingBehaviour;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirementsBehaviour;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.SpeedRequirement;
import com.oierbravo.createmechanicalextruder.foundation.utility.ModLang;
import com.oierbravo.createmechanicalextruder.register.ModRecipes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ExtruderBlockEntity
extends KineticBlockEntity
implements ExtrudingBehaviour.ExtrudingBehaviourSpecifics,
RecipeRequirementsBehaviour.RecipeRequirementsSpecifics<ExtrudingRecipe> {
    public ItemStackHandler outputInv;
    public LazyOptional<IItemHandler> capability;
    public int timer;
    private ExtrudingBehaviour extrudingBehaviour;
    private FilteringBehaviour filtering;
    public RecipeRequirementsBehaviour<ExtrudingRecipe> recipeRequirementsBehaviour;
    private final Map<Direction, Direction> directionLefttBlockMap = Map.of(Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH);
    private final Map<Direction, Direction> directionRightBlockMap = Map.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.WEST, Direction.SOUTH, Direction.EAST, Direction.NORTH);

    public ExtruderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.outputInv = new ItemStackHandler(1);
        this.capability = LazyOptional.of(() -> new ExtruderInventoryHandler());
    }

    public boolean isSpeedRequirementFulfilled() {
        Optional<ExtrudingRecipe> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            return super.isSpeedRequirementFulfilled();
        }
        if (((RecipeRequirement)recipe.get().getRequirement(SpeedRequirement.TYPE)).isPresent()) {
            return ((RecipeRequirement)recipe.get().getRequirement(SpeedRequirement.TYPE)).test(this.f_58857_, (BlockEntity)this);
        }
        return super.isSpeedRequirementFulfilled();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new ExtruderFilterSlotPositioning()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.extrudingBehaviour = new ExtrudingBehaviour(this);
        behaviours.add(this.extrudingBehaviour);
        this.recipeRequirementsBehaviour = new RecipeRequirementsBehaviour(this);
        behaviours.add(this.recipeRequirementsBehaviour);
    }

    public ExtrudingBehaviour getExtrudingBehaviour() {
        return this.extrudingBehaviour;
    }

    public RecipeRequirementsBehaviour<ExtrudingRecipe> getRecipeConditionsBehaviour() {
        return this.recipeRequirementsBehaviour;
    }

    @Override
    public void onExtrudingCompleted() {
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean tryProcess(boolean simulate) {
        Optional<ExtrudingRecipe> recipe = this.getRecipe();
        if (!this.recipeRequirementsBehaviour.checkRequirements(recipe, this.f_58857_, this)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        int requiredBonks = recipe.get().getRequiredBonks();
        int currentBonks = this.extrudingBehaviour.addBonk();
        if (currentBonks < requiredBonks) {
            this.m_6596_();
            return true;
        }
        this.extrudingBehaviour.resetBonks();
        ItemStack output = recipe.get().getResult().rollOutput();
        if (this.outputInv.getStackInSlot(0).m_41619_()) {
            this.outputInv.setStackInSlot(0, output);
        } else if (this.outputInv.getStackInSlot(0).m_150930_(recipe.get().getResult().getStack().m_41720_())) {
            this.outputInv.getStackInSlot(0).m_41769_(output.m_41613_());
        }
        return true;
    }

    public Optional<ExtrudingRecipe> getRecipe() {
        return ModRecipes.findExtruding(this, this.f_58857_);
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addedRequirements;
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        int currentBonks = this.extrudingBehaviour.getBonks();
        if (currentBonks > 0) {
            ModLang.translate("goggles.bonks", currentBonks).forGoggles(tooltip, 1);
            added = true;
        }
        if (addedRequirements = this.recipeRequirementsBehaviour.addToGoggleTooltip(tooltip, isPlayerSneaking, added)) {
            added = true;
        }
        return added;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public Block getLeftBlock() {
        BlockPos currentPos = this.m_58899_();
        Direction localDir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        return this.f_58857_.m_8055_(currentPos.m_121945_(this.directionLefttBlockMap.get(localDir))).m_60734_();
    }

    private Block getRightBlock() {
        BlockPos currentPos = this.m_58899_();
        Direction localDir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        return this.f_58857_.m_8055_(currentPos.m_121945_(this.directionRightBlockMap.get(localDir))).m_60734_();
    }

    private Block getBelowBlock() {
        BlockPos currentPos = this.m_58899_();
        return this.f_58857_.m_8055_(currentPos.m_7495_()).m_60734_();
    }

    public NonNullList<Ingredient> getItemIngredients() {
        NonNullList itemIngredients = NonNullList.m_122779_();
        Block leftBlock = this.getLeftBlock();
        Block rightBlock = this.getRightBlock();
        if (!(leftBlock instanceof LiquidBlock)) {
            itemIngredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{leftBlock.m_5456_()}));
        }
        if (!(rightBlock instanceof LiquidBlock)) {
            itemIngredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rightBlock.m_5456_()}));
        }
        return itemIngredients;
    }

    public NonNullList<FluidIngredient> getFluidIngredients() {
        NonNullList fluidIngredients = NonNullList.m_122779_();
        Block leftBlock = this.getLeftBlock();
        Block rightBlock = this.getRightBlock();
        if (leftBlock instanceof LiquidBlock) {
            fluidIngredients.add((Object)FluidIngredient.fromFluid((Fluid)((LiquidBlock)leftBlock).getFluid(), (int)1000));
        }
        if (rightBlock instanceof LiquidBlock) {
            fluidIngredients.add((Object)FluidIngredient.fromFluid((Fluid)((LiquidBlock)rightBlock).getFluid(), (int)1000));
        }
        return fluidIngredients;
    }

    public Item getCatalystItem() {
        Block below = this.getBelowBlock();
        return below.m_5456_();
    }

    public List<String> getAllIngredientsStringList() {
        ArrayList<String> list = new ArrayList<String>();
        this.getItemIngredients().forEach(ingredient -> list.add(!ingredient.m_43947_() ? ingredient.m_43908_()[0].m_41720_().toString() : ItemStack.f_41583_.toString()));
        this.getFluidIngredients().forEach(ingredient -> list.add(((FluidStack)ingredient.getMatchingFluidStacks().get(0)).getFluid().getFluidType().getDescriptionId()));
        Collections.sort(list);
        return list;
    }

    @Override
    public boolean hasEnoughOutputSpace() {
        if (this.outputInv.getStackInSlot(0).m_41613_() == this.outputInv.getStackInSlot(0).m_41741_()) {
            return false;
        }
        return this.outputInv.getStackInSlot(0).m_41619_() || this.outputInv.getStackInSlot(0).m_150930_(this.getRecipe().get().getResult().getStack().m_41720_());
    }

    @Override
    public boolean matchIngredients(ExtrudingRecipe extrudingRecipe) {
        return ExtrudingRecipe.match(this, extrudingRecipe);
    }

    private class ExtruderInventoryHandler
    extends CombinedInvWrapper {
        public ExtruderInventoryHandler() {
            super(new IItemHandlerModifiable[]{ExtruderBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (ExtruderBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate) {
                ExtruderBlockEntity.this.notifyUpdate();
            }
            return super.extractItem(slot, amount, simulate);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    }

    class ExtruderValueBox
    extends ValueBoxTransform.Sided {
        ExtruderValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)15.75);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

