/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.compat.jei;

import com.oierbravo.createmechanicalextruder.compat.jei.animations.AnimatedExtruder;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.BiomeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.MaxHeightRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.MinHeightRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.SpeedRequirement;
import com.oierbravo.createmechanicalextruder.foundation.utility.ModLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ExtrudingCategory
extends CreateRecipeCategory<ExtrudingRecipe> {
    private AnimatedExtruder extruder = new AnimatedExtruder();
    public static final ResourceLocation UID = new ResourceLocation("create_mechanical_extruder", "extruding");

    public ExtrudingCategory(CreateRecipeCategory.Info<ExtrudingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ExtrudingRecipe recipe, IFocusGroup focuses) {
        int i;
        int slotIndex = 0;
        int initX = 12;
        int initY = 30;
        int distance = 42;
        for (i = 0; i < recipe.getItemIngredients().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, initX + distance * slotIndex, initY).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addIngredients(recipe.getItemIngredients().get(i));
            ++slotIndex;
        }
        for (i = 0; i < recipe.getFluidIngredients().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, initX + distance * slotIndex, initY).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidIngredients().get(i).getMatchingFluidStacks());
            ++slotIndex;
        }
        if (!recipe.getCatalyst().m_41619_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 57).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.getCatalyst());
        }
        ProcessingOutput output = recipe.getResult();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 130, 29).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addRichTooltipCallback(ExtrudingCategory.addStochasticTooltip((ProcessingOutput)output)).addItemStack(recipe.getResult().getStack());
    }

    public void draw(ExtrudingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 80, 32);
        this.extruder.draw(graphics, 53, 55);
        this.drawBonks(recipe, graphics, 55, 55);
        this.drawBiome(recipe, graphics, 55, 65);
        this.drawMinHeight(recipe, graphics, 55, 13);
        this.drawMaxHeight(recipe, graphics, 55, 3);
        this.drawMinSpeed(recipe, graphics, 100, 55);
    }

    protected void drawBonks(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        guiGraphics.m_280056_(fontRenderer, ModLang.translate("goggles.bonks", recipe.getRequiredBonks()).string(), x, y, -8355712, false);
    }

    protected void drawBiome(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        try {
            BiomeRequirement biomeRequirement = recipe.getRequirement(BiomeRequirement.TYPE);
            if (biomeRequirement.isPresent()) {
                Minecraft minecraft = Minecraft.m_91087_();
                Font fontRenderer = minecraft.f_91062_;
                guiGraphics.m_280056_(fontRenderer, biomeRequirement.toString(), x, y, -8355712, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawMinHeight(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        try {
            MinHeightRequirement minHeightRequirement = (MinHeightRequirement)recipe.getRequirement(MinHeightRequirement.TYPE);
            if (minHeightRequirement.isPresent()) {
                Minecraft minecraft = Minecraft.m_91087_();
                Font fontRenderer = minecraft.f_91062_;
                guiGraphics.m_280056_(fontRenderer, ModLang.translate("ui.recipe_requirement.min_height", minHeightRequirement.toString()).string(), x, y, -8355712, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawMaxHeight(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        try {
            MaxHeightRequirement maxHeightRequirement = (MaxHeightRequirement)recipe.getRequirement(MaxHeightRequirement.TYPE);
            if (maxHeightRequirement.isPresent()) {
                Minecraft minecraft = Minecraft.m_91087_();
                Font fontRenderer = minecraft.f_91062_;
                guiGraphics.m_280056_(fontRenderer, ModLang.translate("ui.recipe_requirement.max_height", maxHeightRequirement.toString()).string(), x, y, -8355712, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawMinSpeed(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        try {
            SpeedRequirement speedRequirement = (SpeedRequirement)recipe.getRequirement(SpeedRequirement.TYPE);
            if (speedRequirement.isPresent()) {
                Minecraft minecraft = Minecraft.m_91087_();
                Font fontRenderer = minecraft.f_91062_;
                guiGraphics.m_280056_(fontRenderer, ModLang.translate("ui.recipe_requirement.min_speed", speedRequirement.toString()).string(), x, y, -8355712, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

