/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.placement.SourcePlacement;

public class ECFeatures {
    private static final int RADIUS = 400;
    private static final DeferredRegister<Feature<?>> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"elementalcraft");
    public static final RegistryObject<Feature<IElementTypeFeatureConfig>> SOURCE = DEFERRED_REGISTER.register("source", SourceFeature::new);

    private ECFeatures() {
    }

    public static void addSpawnSources(ServerLevel level) {
        if (Boolean.TRUE.equals(ECConfig.COMMON.disableSourceSpawn.get())) {
            return;
        }
        BlockPos pos = level.m_220360_().m_7918_(-200, 0, -200);
        for (ElementType type : ElementType.ALL_VALID) {
            for (int i = 0; i < (Integer)ECConfig.COMMON.sourceSpawnCount.get(); ++i) {
                ECFeatures.addSpawnSource(level, pos.m_7918_(level.f_46441_.m_188503_(400), 0, level.f_46441_.m_188503_(400)), type);
            }
        }
    }

    private static void addSpawnSource(ServerLevel level, BlockPos pos, ElementType type) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos newPos = new BlockPos(x, SourcePlacement.getHeight((LevelAccessor)level, x, z), z);
        ChunkPos chunkPos = new ChunkPos(pos);
        ServerChunkCache chunkProvider = level.m_7726_();
        chunkProvider.m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        SourceFeature.placeSource((ServerLevelAccessor)level, newPos, type, 0);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

