/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import sirttas.elementalcraft.spell.Spell;

public class AoeSpell
extends Spell {
    protected AoeSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Level level = caster.m_9236_();
        float range = this.getRange(caster);
        if (caster instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)caster;
            AttributeInstance attribute = livingSender.m_21051_(Attributes.f_22281_);
            float damageBase = attribute != null ? (float)attribute.m_22135_() : 1.0f;
            float damageMultiplier = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)livingSender);
            for (LivingEntity target : level.m_45976_(LivingEntity.class, livingSender.m_20191_().m_82377_((double)(range + 1.0f), 0.25, (double)(range + 1.0f)))) {
                this.hitTarget(livingSender, target, damageBase, damageMultiplier);
            }
            level.m_6263_(null, livingSender.m_20185_(), livingSender.m_20186_(), livingSender.m_20189_(), SoundEvents.f_12317_, livingSender.m_5720_(), 1.0f, 1.0f);
            livingSender.m_6674_(InteractionHand.MAIN_HAND);
            if (livingSender instanceof Player) {
                Player playerSender = (Player)livingSender;
                playerSender.m_36346_();
                playerSender.m_36334_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void hitTarget(LivingEntity sender, LivingEntity target, float damageBase, float damageMultiplier) {
        float damage;
        ArmorStand stand;
        float range = this.getRange((Entity)sender);
        if (!(target == sender || sender.m_7307_((Entity)target) || target instanceof ArmorStand && (stand = (ArmorStand)target).m_31677_() || !(sender.m_20280_((Entity)target) < (double)(range * range)) || !((damage = damageMultiplier * (damageBase + EnchantmentHelper.m_44833_((ItemStack)sender.m_21205_(), (MobType)target.m_6336_()))) > 0.0f))) {
            DamageSource damageSource;
            DamageSources sources = sender.m_9236_().m_269111_();
            target.m_147240_((double)0.4f, sender.m_20185_() - target.m_20185_(), sender.m_20189_() - target.m_20189_());
            if (sender instanceof Player) {
                Player player = (Player)sender;
                damageSource = sources.m_269075_(player);
            } else {
                damageSource = sources.m_269333_(sender);
            }
            target.m_6469_(damageSource, damage);
            this.onHit(sender, target, damage);
            EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)sender);
            EnchantmentHelper.m_44896_((LivingEntity)sender, (Entity)target);
            this.hitWithItem(sender, target);
        }
    }

    protected void onHit(LivingEntity sender, LivingEntity target, float damage) {
    }

    private void hitWithItem(LivingEntity sender, LivingEntity target) {
        ItemStack stack = sender.m_21205_();
        if (!stack.m_41619_() && sender instanceof Player) {
            Player player = (Player)sender;
            ItemStack copy = stack.m_41777_();
            stack.m_41720_().m_7579_(stack, target, (LivingEntity)player);
            if (stack.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                sender.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
    }
}

