/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.renderer.ECRenderTypes;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandlerHelper;
import sirttas.elementalcraft.event.TickHandler;

public class ECRendererHelper {
    public static final float SPACING = 0.001f;

    private ECRendererHelper() {
    }

    public static Material getBlockMaterial(String name) {
        return ECRendererHelper.getBlockMaterial(ElementalCraft.createRL(name));
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.f_118259_, loc);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, Material renderMaterial, int width, int height) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.m_119194_(buffer, RenderType::m_110473_), 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, Material renderMaterial, int width, int height, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.m_119194_(buffer, RenderType::m_110473_), 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, VertexConsumer builder, int width, int height, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, builder, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, float x, float y, Material renderMaterial, int width, int height, float r, float g, float b, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.m_119194_(buffer, RenderType::m_110473_), x, y, width, height, r, g, b, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, VertexConsumer builder, float x, float y, int width, int height, float r, float g, float b, int light, int overlay) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        builder.m_252986_(matrix, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, x + (float)width, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, x + (float)width, y + (float)height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, x, y + (float)height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> Axis.f_252436_.m_252977_(180.0f);
            case Direction.WEST -> Axis.f_252436_.m_252977_(90.0f);
            case Direction.EAST -> Axis.f_252436_.m_252977_(-90.0f);
            default -> new Quaternionf();
        };
    }

    public static void renderItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, poseStack, buffer, null, 0);
    }

    public static void renderBlock(BlockState state, PoseStack poseStack, MultiBufferSource buffer) {
        ECRendererHelper.renderBlock(state, poseStack, buffer, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY);
    }

    public static void renderBlock(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, ModelData data) {
        if (state.m_60795_()) {
            return;
        }
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, poseStack, buffer, light, overlay, data, null);
    }

    public static void renderGhost(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos) {
        ECRendererHelper.renderBatched(state, poseStack, buffer.m_6299_(ECRenderTypes.GHOST), level, pos);
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, VertexConsumer consumer, Level level, BlockPos pos) {
        poseStack.m_85836_();
        Minecraft.m_91087_().m_91289_().renderBatched(state, pos, (BlockAndTintGetter)level, poseStack, consumer, false, level.f_46441_, ECRendererHelper.getModelData(level, pos), null);
        poseStack.m_85849_();
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos) {
        ECRendererHelper.renderBatched(state, poseStack, buffer, level, pos, ECRendererHelper.getModelData(level, pos));
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos, ModelData data) {
        poseStack.m_85836_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        RandomSource rand = level.f_46441_;
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            BakedModel model = blockRenderer.m_110910_(state);
            for (RenderType renderType : model.getRenderTypes(state, rand, data)) {
                VertexConsumer consumer = buffer.m_6299_(renderType);
                blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)level, poseStack, consumer, false, rand, data, renderType);
            }
        }
        poseStack.m_85849_();
    }

    public static void renderFluid(BlockState state, PoseStack poseStack, MultiBufferSource buffer) {
        FluidState fluidState = state.m_60819_();
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
        ResourceLocation overlayTexture = props.getOverlayTexture();
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{(TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(props.getStillTexture()), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(props.getFlowingTexture()), overlayTexture == null ? null : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(overlayTexture)};
        VertexConsumer consumer = buffer.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)fluidState));
        int tintColor = props.getTintColor();
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tintColor & 0xFF) / 255.0f;
        TextureAtlasSprite sprite1 = sprites[0];
        float f18 = sprite1.m_118367_(0.0);
        float f22 = sprite1.m_118393_(0.0);
        float f19 = f18;
        float f23 = sprite1.m_118393_(16.0);
        float f20 = sprite1.m_118367_(16.0);
        float f24 = f23;
        float f21 = f20;
        float f25 = f22;
        float f49 = (f18 + f19 + f20 + f21) / 4.0f;
        float f50 = (f22 + f23 + f24 + f25) / 4.0f;
        float f51 = sprite1.m_118417_();
        f18 = Mth.m_14179_((float)f51, (float)f18, (float)f49);
        f19 = Mth.m_14179_((float)f51, (float)f19, (float)f49);
        f20 = Mth.m_14179_((float)f51, (float)f20, (float)f49);
        f21 = Mth.m_14179_((float)f51, (float)f21, (float)f49);
        f22 = Mth.m_14179_((float)f51, (float)f22, (float)f50);
        f23 = Mth.m_14179_((float)f51, (float)f23, (float)f50);
        f24 = Mth.m_14179_((float)f51, (float)f24, (float)f50);
        f25 = Mth.m_14179_((float)f51, (float)f25, (float)f50);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.999f, 0.0f, r, g, b, alpha, f18, f22);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.999f, 1.0f, r, g, b, alpha, f19, f23);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.999f, 1.0f, r, g, b, alpha, f20, f24);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.999f, 0.0f, r, g, b, alpha, f21, f25);
        float f40 = sprite1.m_118409_();
        float f41 = sprite1.m_118410_();
        float f42 = sprite1.m_118411_();
        float f43 = sprite1.m_118412_();
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.001f, 1.0f, r, g, b, alpha, f40, f43);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.001f, 0.0f, r, g, b, alpha, f40, f42);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.001f, 0.0f, r, g, b, alpha, f41, f42);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.001f, 1.0f, r, g, b, alpha, f41, f43);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            float d4;
            float d5;
            float d3;
            float f45;
            float f44;
            float d6 = switch (direction) {
                case Direction.NORTH -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.0f;
                    d5 = 1.0f;
                    d4 = 0.001f;
                    yield 0.001f;
                }
                case Direction.SOUTH -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 1.0f;
                    d5 = 0.0f;
                    d4 = 0.999f;
                    yield 0.999f;
                }
                case Direction.WEST -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.001f;
                    d5 = 0.001f;
                    d4 = 1.0f;
                    yield 0.0f;
                }
                default -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.999f;
                    d5 = 0.999f;
                    d4 = 0.0f;
                    yield 1.0f;
                }
            };
            TextureAtlasSprite sprite2 = sprites[2] != null ? sprites[2] : sprites[1];
            float f54 = sprite2.m_118367_(0.0);
            float f55 = sprite2.m_118367_(8.0);
            float f33 = sprite2.m_118393_((double)((1.0f - f44) * 16.0f * 0.5f));
            float f34 = sprite2.m_118393_((double)((1.0f - f45) * 16.0f * 0.5f));
            float f35 = sprite2.m_118393_(8.0);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, f44, d4, r, g, b, alpha, f54, f33);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, f45, d6, r, g, b, alpha, f55, f34);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, 0.001f, d6, r, g, b, alpha, f55, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, 0.001f, d4, r, g, b, alpha, f54, f35);
            if (sprite2 == ModelBakery.f_119223_.m_119204_()) continue;
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, 0.001f, d4, r, g, b, alpha, f54, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, 0.001f, d6, r, g, b, alpha, f55, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, f45, d6, r, g, b, alpha, f55, f34);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, f44, d4, r, g, b, alpha, f54, f33);
        }
    }

    private static void fluidVertex(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z, float r, float g, float b, float alpha, float u, float v) {
        PoseStack.Pose last = poseStack.m_85850_();
        consumer.m_252986_(last.m_252922_(), x, y, z).m_85950_(r, g, b, alpha).m_7421_(u, v).m_85969_(0xF000F0).m_252939_(last.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderRunes(PoseStack poseStack, MultiBufferSource buffer, ICapabilityProvider cap, float tick, int light, int overlay) {
        ECRendererHelper.renderRunes(poseStack, buffer, RuneHandlerHelper.get(cap), ECRendererHelper.getClientTicks(tick), light, overlay);
    }

    public static void renderRunes(PoseStack poseStack, MultiBufferSource buffer, IRuneHandler handler, float tick, int light, int overlay) {
        int runeCount = handler.getRuneCount();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.75f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(tick / 2.0f));
        handler.getRunes().forEach(rune -> {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f / (float)runeCount));
            poseStack.m_85836_();
            poseStack.m_252880_(0.75f, 0.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_85841_(0.015625f, 0.015625f, 0.015625f);
            ECRendererHelper.renderIcon(poseStack, buffer, rune.getSprite(), 16, -16, light, overlay);
            poseStack.m_85849_();
        });
        poseStack.m_85849_();
    }

    @Deprecated
    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay) {
        ECRendererHelper.renderModel(model, matrixStack, buffer, state, light, overlay, ModelData.EMPTY);
    }

    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay, ModelData data) {
        RenderType renderType = state != null ? ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false) : Sheets.m_110790_();
        Minecraft.m_91087_().m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(renderType), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data, renderType);
    }

    public static float getClientTicks(float partialTicks) {
        return (float)TickHandler.getTicksInGame() + partialTicks;
    }

    public static ModelData getModelData(Level level, BlockPos pos) {
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager == null) {
            return ModelData.EMPTY;
        }
        ModelData data = modelDataManager.getAt(pos);
        if (data == null) {
            return ModelData.EMPTY;
        }
        return data;
    }

    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockEntity te, int light, int overlay) {
        ECRendererHelper.renderModel(model, matrixStack, buffer, te.m_58900_(), light, overlay, ECRendererHelper.getModelData(model, te));
    }

    public static ModelData getModelData(BakedModel model, BlockEntity te) {
        Level level = te.m_58904_();
        BlockPos pos = te.m_58899_();
        if (level == null) {
            return ModelData.EMPTY;
        }
        return model.getModelData((BlockAndTintGetter)level, pos, te.m_58900_(), ECRendererHelper.getModelData(level, pos));
    }
}

