/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.event.DataPackReloadCompleteEvent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.color.ECColorHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.loader.IPureOreLoader;
import sirttas.elementalcraft.recipe.instrument.io.IPurifierRecipe;

public class PureOreManager {
    private final Map<ResourceLocation, Entry> pureOres = new HashMap<ResourceLocation, Entry>();
    private Language language;

    public boolean isValidOre(ItemStack ore) {
        return this.pureOres.values().stream().anyMatch(e -> e.test(ore));
    }

    public ResourceLocation getPureOreId(ItemStack stack) {
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (nbt != null) {
            return new ResourceLocation(nbt.m_128461_("ore"));
        }
        return null;
    }

    public IPurifierRecipe getRecipes(ItemStack ore, @Nonnull Level level) {
        return this.pureOres.values().stream().filter(e -> e.test(ore)).mapMulti((e, downstream) -> e.getRecipes().forEach(downstream)).filter(r -> r.matches(ore, level)).findAny().orElse(null);
    }

    public static Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> getInjectors() {
        return AbstractPureOreRecipeInjector.REGISTRY.getValues();
    }

    public Component getPureOreName(ItemStack stack) {
        ResourceLocation id = this.getPureOreId(stack);
        if (this.language == null) {
            this.language = Language.m_128107_();
        }
        if (id == null) {
            return null;
        }
        if (this.language.m_6722_("tooltip.elementalcraft.pure_ore." + id.m_135827_() + "." + id.m_135815_())) {
            return Component.m_237115_((String)("tooltip.elementalcraft.pure_ore." + id.m_135827_() + "." + id.m_135815_()));
        }
        Entry entry = this.pureOres.get(id);
        return entry != null ? entry.getDescription() : null;
    }

    public ItemStack createPureOre(ResourceLocation id) {
        if (this.pureOres.containsKey(id)) {
            ItemStack stack = new ItemStack((ItemLike)ECItems.PURE_ORE.get());
            NBTHelper.getOrCreateECTag(stack).m_128359_("ore", id.toString());
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int[] getColors(ItemStack stack) {
        Entry entry = this.pureOres.get(this.getPureOreId(stack));
        return entry != null ? entry.getColors() : null;
    }

    public List<ResourceLocation> getOres() {
        return new ArrayList<ResourceLocation>(this.pureOres.keySet());
    }

    public List<IPurifierRecipe> getRecipes() {
        return this.pureOres.values().stream().mapMulti((e, downstream) -> e.getRecipes().forEach(downstream)).toList();
    }

    public void reload(DataPackReloadCompleteEvent event) {
        Instant start = Instant.now();
        RecipeManager recipeManager = event.getRecipeManager();
        Collection<AbstractPureOreRecipeInjector<?, Recipe<?>>> injectors = PureOreManager.getInjectors();
        RegistryAccess registry = event.getRegistry();
        ElementalCraftApi.LOGGER.info("Pure ore generation started.\n\r\tRecipe Types: {}", new Supplier[]{() -> injectors.stream().map(AbstractPureOreRecipeInjector::toString).collect(Collectors.joining(", "))});
        injectors.forEach(injector -> injector.init(recipeManager));
        this.pureOres.clear();
        ElementalCraft.PURE_ORE_LOADERS_MANAGER.getData().entrySet().stream().map(Map.Entry::getValue).sorted(Comparator.comparingInt(IPureOreLoader::getOrder)).forEach(l -> l.generate(registry, injectors).forEach(e -> this.pureOres.computeIfAbsent((ResourceLocation)e.getId(), (Function<ResourceLocation, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$7(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lsirttas/elementalcraft/pureore/PureOreManager$Entry;)()).ores.put((IPureOreLoader)l, (PureOre)e)));
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreRecipeInjection.get())) {
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection.");
            this.pureOres.values().removeIf(o -> !o.isProcessable());
            List<Entry> entries = this.pureOres.values().stream().distinct().toList();
            List recipes = recipeManager.m_44051_().stream().filter(r -> !this.isPureOreRecipe((Recipe<?>)r)).collect(Collectors.toList());
            int size = recipes.size();
            injectors.forEach(injector -> this.inject(registry, (AbstractPureOreRecipeInjector)injector, recipes, entries));
            recipeManager.m_44024_(recipes);
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection finished. {} recipes added.", new Supplier[]{() -> recipeManager.m_44051_().size() - size});
        }
        ElementalCraftApi.LOGGER.info("Pure ore generation ended in {}ms\r\n\tOres: {}.", new Supplier[]{() -> Duration.between(start, Instant.now()).toMillis(), () -> this.pureOres.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))});
    }

    private boolean isPureOreRecipe(Recipe<?> recipe) {
        ResourceLocation id = recipe.m_6423_();
        return id.m_135827_().equals("elementalcraft") && id.m_135815_().startsWith("pure_ore/");
    }

    private <C extends Container, T extends Recipe<C>> void inject(@Nonnull RegistryAccess registry, @Nonnull AbstractPureOreRecipeInjector<C, T> injector, @Nonnull Collection<Recipe<?>> recipes, @Nonnull List<Entry> entries) {
        entries.stream().distinct().mapMulti((entry, downstream) -> entry.ores.values().forEach(v -> downstream.accept(this.injectEntry(registry, injector, (PureOre)v)))).filter(Objects::nonNull).filter(ElementalCraftUtils.distinctBy(Recipe::m_6423_)).forEach(recipes::add);
    }

    private <C extends Container, T extends Recipe<C>> T injectEntry(@Nonnull RegistryAccess registry, @Nonnull AbstractPureOreRecipeInjector<C, T> injector, @Nonnull PureOre entry) {
        RecipeType<T> recipeType = injector.getRecipeType();
        try {
            T recipe = entry.getRecipe(recipeType);
            return recipe != null ? (T)injector.build(registry, recipe, (Ingredient)StrictNBTIngredient.of((ItemStack)this.createPureOre(entry.getId()))) : null;
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.error("Error in pure ore recipe injection", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ Entry lambda$reload$7(ResourceLocation i) {
        return new Entry();
    }

    private static class Entry {
        private int[] colors = null;
        private final Map<IPureOreLoader, PureOre> ores = new Reference2ObjectArrayMap(ElementalCraft.PURE_ORE_LOADERS_MANAGER.getData().size());

        public Component getDescription() {
            if (this.ores.isEmpty()) {
                return null;
            }
            return this.ores.values().iterator().next().getDescription();
        }

        public boolean test(ItemStack ore) {
            return !this.ores.isEmpty() && this.ores.values().stream().anyMatch(o -> o.getIngredient().test(ore));
        }

        public boolean isProcessable() {
            return !this.ores.isEmpty() && this.ores.values().stream().anyMatch(PureOre::isProcessable);
        }

        public List<IPurifierRecipe> getRecipes() {
            return this.ores.values().stream().map(PureOre::getRecipe).toList();
        }

        @OnlyIn(value=Dist.CLIENT)
        private int[] getColors() {
            if (this.colors == null) {
                this.colors = this.ores.values().stream().map(o -> ECColorHelper.lookupColors(o.getResultForColor())).findFirst().orElse(null);
            }
            return this.colors;
        }
    }
}

