/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgePlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorListMessage;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockItem;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.air.TranslocationSpell;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity
implements IForgePlayer {
    protected MixinPlayer(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="net.minecraft.world.item.ItemStack.isSameItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    private void tick$invoke$isSameItem(CallbackInfo ci) {
        ServerPlayer serverPlayer;
        Player player = this.self();
        if (player instanceof ServerPlayer && MixinPlayer.shouldSendAnchors(serverPlayer = (ServerPlayer)player)) {
            MessageHelper.sendToPlayer(serverPlayer, TranslocationAnchorListMessage.create(serverPlayer.m_9236_()));
        }
    }

    private static boolean shouldSendAnchors(ServerPlayer serverPlayer) {
        return TranslocationSpell.holdsTranslocation((Player)serverPlayer) || TranslocationShrineUpgradeBlockItem.getTargetAnchor((Player)serverPlayer) != null;
    }

    @Unique
    public Player self() {
        return (Player)this;
    }
}

