/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.mekanism;

import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.CrushingIRecipe;
import mekanism.common.recipe.impl.EnrichingIRecipe;
import mekanism.common.recipe.impl.InjectingIRecipe;
import mekanism.common.recipe.impl.PurifyingIRecipe;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.AbstractMillGrindstoneBlockEntity;
import sirttas.elementalcraft.interaction.mekanism.injector.ChemicalDissolutionPureOreRecipeInjector;
import sirttas.elementalcraft.interaction.mekanism.injector.ItemStackGasToItemStackPureOreRecipeInjector;
import sirttas.elementalcraft.interaction.mekanism.injector.ItemStackToItemStackPureOreRecipeInjector;
import sirttas.elementalcraft.interaction.mekanism.recipe.MekanismCrusherRecipeWrapper;
import sirttas.elementalcraft.pureore.injector.PureOreRecipeInjectors;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public class MekanismInteraction {
    private MekanismInteraction() {
    }

    public static void registerPureOreRecipeInjectors(IForgeRegistry<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> registry) {
        PureOreRecipeInjectors.register(registry, new ChemicalDissolutionPureOreRecipeInjector((RecipeTypeRegistryObject<ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>>)MekanismRecipeType.DISSOLUTION));
        PureOreRecipeInjectors.register(registry, new ItemStackGasToItemStackPureOreRecipeInjector<ItemStackGasToItemStackRecipe>(MekanismRecipeType.INJECTING, InjectingIRecipe::new));
        PureOreRecipeInjectors.register(registry, new ItemStackGasToItemStackPureOreRecipeInjector<ItemStackGasToItemStackRecipe>(MekanismRecipeType.PURIFYING, PurifyingIRecipe::new));
        PureOreRecipeInjectors.register(registry, new ItemStackToItemStackPureOreRecipeInjector<ItemStackToItemStackRecipe>(MekanismRecipeType.ENRICHING, EnrichingIRecipe::new));
        PureOreRecipeInjectors.register(registry, new ItemStackToItemStackPureOreRecipeInjector<ItemStackToItemStackRecipe>(MekanismRecipeType.CRUSHING, CrushingIRecipe::new));
    }

    public static void addAirMillToCrushing(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get()), new RecipeType[]{MekanismJEI.recipeType((MekanismJEIRecipeType)MekanismJEIRecipeType.CRUSHING)});
    }

    public static IGrindingRecipe lookupCrusherRecipe(Level level, AbstractMillGrindstoneBlockEntity millGrindstone) {
        ItemStack stack = millGrindstone.getInventory().m_8020_(0);
        ItemStackToItemStackRecipe crusherRecipe = (ItemStackToItemStackRecipe)MekanismRecipeType.CRUSHING.findFirst(level, recipe -> recipe.test(stack));
        MekanismCrusherRecipeWrapper wrapper = crusherRecipe != null ? new MekanismCrusherRecipeWrapper(crusherRecipe) : null;
        return wrapper != null && wrapper.matches(millGrindstone, level) ? wrapper : null;
    }
}

