/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.shrine;

import javax.annotation.Nonnull;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.shrine.AbstractShrineRecipeCategory;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SpringShrineRecipeCategory
extends AbstractShrineRecipeCategory<SpringShrineBlock> {
    private final BlockState water = Blocks.f_49990_.m_49966_();
    private final BlockState springShrine = ((SpringShrineBlock)ECBlocks.SPRING_SHRINE.get()).m_49966_();
    private final ITickTimer timer;

    public SpringShrineRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.springshrine", SpringShrineRecipeCategory.createDrawableStack(guiHelper, new ItemStack((ItemLike)ECBlocks.SPRING_SHRINE.get())), (IDrawable)guiHelper.createBlankDrawable(110, 80));
        this.timer = guiHelper.createTickTimer(40, 1, false);
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/overlay/extraction.png"), 0, 0, 24, 9), 61, 64);
    }

    @Nonnull
    public RecipeType<SpringShrineBlock> getRecipeType() {
        return ECJEIRecipeTypes.SPRING_SHRINE;
    }

    @Override
    public void draw(@Nonnull SpringShrineBlock recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        SpringShrineRecipeCategory.render3D(guiGraphics, (p, b) -> {
            SpringShrineRecipeCategory.setupPose(p);
            ECRendererHelper.renderBlock(this.springShrine, p, b);
            p.m_252880_(0.0f, 1.0f, 0.0f);
            int t = this.timer.getValue();
            if (t == 0) {
                ECRendererHelper.renderFluid(this.water, p, b);
            }
        });
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull SpringShrineBlock recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 60).addFluidStack((Fluid)Fluids.f_76193_, 1000L);
    }
}

