/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.shrine;

import javax.annotation.Nonnull;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlock;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.shrine.AbstractShrineRecipeCategory;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.tag.ECTags;

public class LavaShrineRecipeCategory
extends AbstractShrineRecipeCategory<LavaShrineBlock> {
    private final BlockState lava = Blocks.f_49991_.m_49966_();
    private final BlockState lavaShrine = ((LavaShrineBlock)ECBlocks.LAVA_SHRINE.get()).m_49966_();
    private final Block[] liquifiables = (Block[])ECTags.Blocks.getTag(ECTags.Blocks.SHRINES_LAVA_LIQUIFIABLES).m_203614_().map(Holder::get).toArray(Block[]::new);
    private final ITickTimer timer;

    public LavaShrineRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.lavashrine", LavaShrineRecipeCategory.createDrawableStack(guiHelper, new ItemStack((ItemLike)ECBlocks.LAVA_SHRINE.get())), (IDrawable)guiHelper.createBlankDrawable(121, 80));
        int l = this.liquifiables.length * 2;
        this.timer = guiHelper.createTickTimer(l * 20, l, false);
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/overlay/extraction.png"), 0, 0, 24, 9), 72, 64);
    }

    @Nonnull
    public RecipeType<LavaShrineBlock> getRecipeType() {
        return ECJEIRecipeTypes.LAVA_SHRINE;
    }

    @Override
    public void draw(@Nonnull LavaShrineBlock recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        LavaShrineRecipeCategory.render3D(guiGraphics, (p, b) -> {
            LavaShrineRecipeCategory.setupPose(p);
            ECRendererHelper.renderBlock(this.lavaShrine, p, b);
            p.m_252880_(0.0f, 1.0f, 0.0f);
            int t = this.timer.getValue();
            if (t >= this.liquifiables.length) {
                ECRendererHelper.renderFluid(this.lava, p, b);
            } else {
                ECRendererHelper.renderBlock(this.liquifiables[t].m_49966_(), p, b);
            }
        });
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull LavaShrineBlock recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 60).addIngredients(Ingredient.m_43929_((ItemLike[])this.liquifiables));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 60).addFluidStack((Fluid)Fluids.f_76195_, 1000L);
    }
}

